package io.intino.tara.language.semantics.constraints.flags;

import io.intino.tara.dsls.MetaIdentifiers;
import io.intino.tara.language.model.Mogram;
import io.intino.tara.language.model.Tag;
import io.intino.tara.language.semantics.errorcollector.SemanticException;
import io.intino.tara.language.semantics.errorcollector.SemanticNotification;

import java.util.HashMap;
import java.util.Map;

import static java.util.Arrays.asList;

public class AnnotationCoherenceCheckerFactory {

	private static final Map<String, FlagChecker> checkers = new HashMap<>();

	static {
		checkers.put(Tag.Feature.name().toLowerCase(), new FeatureChecker());
	}

	private AnnotationCoherenceCheckerFactory() {
	}


	public static FlagChecker get(Object key) {
		return checkers.get(key.toString());
	}


	private static class FeatureChecker implements FlagChecker {
		@Override
		public void check(Mogram mogram) throws SemanticException {
			if (MetaIdentifiers.CONCEPT.equals(mogram.type())) throw error(mogram);
		}
	}

	public static SemanticException error(Mogram mogram) {
		return new SemanticException(new SemanticNotification(SemanticNotification.Level.ERROR, "reject.flag.combination", mogram, asList(Tag.Concept, Tag.Feature)));
	}
}
