package io.intino.tara.language.semantics.constraints;

import io.intino.tara.language.model.Element;
import io.intino.tara.language.model.Mogram;
import io.intino.tara.language.semantics.Constraint;
import io.intino.tara.language.semantics.errorcollector.SemanticException;
import io.intino.tara.language.semantics.errorcollector.SemanticNotification;

import java.util.Arrays;
import java.util.List;


class MetaFacetConstraint implements Constraint.MetaFacet {

	private final String type;
	private final String[] with;

	MetaFacetConstraint(String type, String[] with) {
		this.type = type;
		this.with = with;
	}

	@Override
	public String type() {
		return type;
	}

	@Override
	public String[] with() {
		return with;
	}

	@Override
	public void check(Element element) throws SemanticException {
		Mogram mogram = (Mogram) element;
		if (!is(mogram.types()))
			throw new SemanticException(new SemanticNotification(SemanticNotification.Level.ERROR, "reject.facet.with.no.constrains.in.context", mogram, Arrays.asList(this.with)));
	}


	private boolean is(List<String> nodeTypes) {
		if (with == null) return true;
		for (String aType : with)
			if (!nodeTypes.contains(aType)) return false;
		return true;
	}

}
