package io.intino.tara.language.model;

import io.intino.tara.language.model.rules.Size;

import java.util.List;
import java.util.stream.Collectors;

public interface MogramContainer extends Element {

	Mogram container();

	default void container(Mogram container) {
	}

	List<Mogram> components();

	List<Mogram> siblings();

	List<Mogram> referenceComponents();

	default void add(Mogram mogram, List<Rule> rule) {

	}

	default List<Mogram> component(String name) {
		return components().stream().filter(component -> name.equals(component.name())).collect(Collectors.toList());
	}

	List<Rule> rulesOf(Mogram component);

	default Size sizeOf(Mogram component) {
		return (Size) rulesOf(component).stream().filter(r -> r instanceof Size).findAny().orElse(Size.MULTIPLE());
	}

	<T extends Mogram> boolean contains(T node);

	default <T extends Mogram> void remove(T node) {
	}

	default <T extends Variable> void add(T... variables) {
	}

	default <T extends Variable> void add(int pos, T... variables) {
	}

	List<String> uses();

	String doc();

	default void doc(String doc) {
	}
}
