package io.intino.tara.dsls;

import io.intino.tara.language.model.rules.Size;
import io.intino.tara.language.semantics.constraints.RuleFactory;

import java.util.Locale;

import static io.intino.tara.language.semantics.constraints.RuleFactory.component;
import static io.intino.tara.language.semantics.constraints.RuleFactory.name;
import static java.util.Collections.singletonList;

public class Proteo extends Tara {
	private static final Size MULTIPLE = new Size(0, Integer.MAX_VALUE);

	public Proteo() {
		def(Tara.Root).with(context(Tara.Root).has(
						component(MetaIdentifiers.CONCEPT, singletonList(MULTIPLE)),
						component(MetaIdentifiers.FACET, singletonList(MULTIPLE))
				)
		);
		def(MetaIdentifiers.CONCEPT).with(context(MetaIdentifiers.META_CONCEPT).has(name(),
						component(MetaIdentifiers.CONCEPT, singletonList(MULTIPLE)),
						component(MetaIdentifiers.FACET, singletonList(MULTIPLE)),
						component(MetaIdentifiers.META_CONCEPT, singletonList(MULTIPLE)),
						component(MetaIdentifiers.META_FACET, singletonList(MULTIPLE)))
				.assume(RuleFactory.isTerminal()));
		def(MetaIdentifiers.FACET).with(context(MetaIdentifiers.FACET).has(name(),
				component(MetaIdentifiers.CONCEPT, singletonList(MULTIPLE))));
	}

	@Override
	public String languageName() {
		return "Proteo";
	}

	@Override
	public Locale locale() {
		return Locale.ENGLISH;
	}

	@Override
	public boolean isTerminalLanguage() {
		return false;
	}

	@Override
	public String metaLanguage() {
		return "";
	}
}