package io.intino.tara.dsls;

import io.intino.tara.language.model.rules.Size;

import java.util.Collections;
import java.util.Locale;

import static io.intino.tara.language.semantics.constraints.RuleFactory.*;

public class Meta extends Tara {
	private static final Size MULTIPLE = new Size(0, Integer.MAX_VALUE);

	public Meta() {
		def(Root).with(context(Root).has(
				component(MetaIdentifiers.CONCEPT, Collections.singletonList(MULTIPLE)),
				component(MetaIdentifiers.FACET, Collections.singletonList(MULTIPLE)),
				component(MetaIdentifiers.META_CONCEPT, Collections.singletonList(MULTIPLE))));
		def(MetaIdentifiers.CONCEPT).with(context(MetaIdentifiers.META_CONCEPT).has(name(),
				component(MetaIdentifiers.META_CONCEPT, Collections.singletonList(MULTIPLE)),
				component(MetaIdentifiers.CONCEPT, Collections.singletonList(MULTIPLE)),
				component(MetaIdentifiers.FACET, Collections.singletonList(MULTIPLE)),
				component(MetaIdentifiers.META_FACET, Collections.singletonList(MULTIPLE)))
				.assume(isTerminal()));
		def(MetaIdentifiers.META_CONCEPT).with(context(MetaIdentifiers.META_CONCEPT).has(name(),
				component(MetaIdentifiers.META_CONCEPT, Collections.singletonList(MULTIPLE)),
				component(MetaIdentifiers.META_FACET, Collections.singletonList(MULTIPLE)),
				component(MetaIdentifiers.FACET, Collections.singletonList(MULTIPLE)),
				component(MetaIdentifiers.CONCEPT, Collections.singletonList(MULTIPLE))));
		def(MetaIdentifiers.FACET).with(context(MetaIdentifiers.META_FACET).has(name(),
				component(MetaIdentifiers.CONCEPT, Collections.singletonList(MULTIPLE))).assume(isTerminal()));
		def(MetaIdentifiers.META_FACET).with(context(MetaIdentifiers.META_FACET).has(name(),
				component(MetaIdentifiers.META_CONCEPT, Collections.singletonList(MULTIPLE)),
				component(MetaIdentifiers.CONCEPT, Collections.singletonList(MULTIPLE))));
	}

	@Override
	public String languageName() {
		return "Meta";
	}

	@Override
	public Locale locale() {
		return Locale.ENGLISH;
	}

	@Override
	public boolean isTerminalLanguage() {
		return false;
	}

	@Override
	public String metaLanguage() {
		return "";
	}
}
