/*
 * Decompiled with CFR 0.152.
 */
package io.intino.tara.language.semantics.constraints.parameter;

import io.intino.tara.language.model.Element;
import io.intino.tara.language.model.Mogram;
import io.intino.tara.language.model.Parameter;
import io.intino.tara.language.semantics.Constraint;
import io.intino.tara.language.semantics.errorcollector.SemanticException;
import java.util.List;

abstract class ParameterConstraint
implements Constraint.Parameter {
    protected ParameterError error = ParameterError.TYPE;

    ParameterConstraint() {
    }

    static Parameter findParameter(List<Parameter> parameters, String facet, String name, int position) {
        for (Parameter parameter : parameters) {
            if (parameter.name().isEmpty() || !parameter.name().equals(name)) continue;
            return parameter;
        }
        return ParameterConstraint.byPosition(parameters, facet, position);
    }

    private static Parameter byPosition(List<Parameter> parameters, String facet, int position) {
        for (Parameter parameter : parameters) {
            if (!parameter.name().isEmpty() || !parameter.facet().equals(facet) || parameter.position() != position) continue;
            return parameter;
        }
        return null;
    }

    boolean isNotAbstractNode(Element element) {
        return element instanceof Mogram && !((Mogram)element).isAbstract() && !this.isInherited((Mogram)element);
    }

    private boolean isInherited(Mogram mogram) {
        Mogram parent = mogram.parent();
        while (parent != null) {
            Parameter parameter = ParameterConstraint.findParameter(mogram.parent().parameters(), "", this.name(), this.position());
            if (parameter != null) {
                return true;
            }
            parent = mogram.parent();
        }
        return false;
    }

    protected abstract void error(Element var1, Parameter var2, ParameterError var3) throws SemanticException;

    static enum ParameterError {
        TYPE,
        NOT_FOUND,
        RECOVERABLE_ERROR,
        RULE,
        SIZE;

    }
}

