/*
 * Decompiled with CFR 0.152.
 */
package io.intino.tara.language.model;

import io.intino.tara.language.model.rules.variable.VariableRule;
import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;

public interface Metric<T>
extends VariableRule<T> {
    public T value(T var1);

    default public List<String> units() {
        return Arrays.asList(this.getClass().getFields()).stream().filter(Field::isEnumConstant).map(Field::getName).collect(Collectors.toList());
    }

    @Override
    default public boolean accept(T value) {
        return true;
    }

    @Override
    default public boolean accept(T value, String metric) {
        return this.units().contains(metric);
    }

    @Override
    default public String errorMessage() {
        return "reject.number.parameter.with.erroneous.metric";
    }

    @Override
    default public List<Object> errorParameters() {
        return Collections.singletonList(String.join((CharSequence)", ", this.units()));
    }

    public static interface Converter<T> {
        public T convert(T var1);
    }
}

