/*
 * Decompiled with CFR 0.152.
 */
package io.intino.tara.language.semantics.constraints.component;

import io.intino.tara.Resolver;
import io.intino.tara.language.model.Element;
import io.intino.tara.language.model.Facet;
import io.intino.tara.language.model.Mogram;
import io.intino.tara.language.model.MogramContainer;
import io.intino.tara.language.model.Rule;
import io.intino.tara.language.model.Tag;
import io.intino.tara.language.model.rules.NodeRule;
import io.intino.tara.language.model.rules.Size;
import io.intino.tara.language.semantics.Constraint;
import io.intino.tara.language.semantics.errorcollector.SemanticException;
import io.intino.tara.language.semantics.errorcollector.SemanticNotification;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Collectors;

public class OneOf
implements Constraint.OneOf {
    private final List<Rule> rules;
    private final List<Constraint.Component> constraints;

    public OneOf(List<Constraint.Component> constraints, List<Rule> rules) {
        this.rules = rules;
        this.constraints = constraints;
    }

    @Override
    public void check(Element element) throws SemanticException {
        Mogram mogram = (Mogram)element;
        ArrayList<String> requireTypes = new ArrayList<String>();
        HashSet<Mogram> accepted = new HashSet<Mogram>();
        for (Constraint constraint : this.constraints) {
            requireTypes.add(Resolver.shortType(((Constraint.Component)constraint).type()));
            try {
                constraint.check(mogram);
            }
            catch (SemanticException semanticException) {
                // empty catch block
            }
            List<Mogram> components = this.filterByType(mogram, (Constraint.Component)constraint);
            List<Mogram> acceptedMograms = this.acceptedComponents(components);
            accepted.addAll(acceptedMograms);
            List<Mogram> notAccepted = this.notAccepted(components, acceptedMograms);
            if (notAccepted.isEmpty()) continue;
            this.error(notAccepted.get(0));
        }
        Size size = this.rules.stream().filter(r -> r instanceof Size).findFirst().orElse(null);
        if (size == null) {
            return;
        }
        if (accepted.isEmpty() && size.isRequired()) {
            throw new SemanticException(new SemanticNotification(SemanticNotification.Level.ERROR, "required.any.type.in.context", element, Collections.singletonList(String.join((CharSequence)", ", requireTypes))));
        }
        if (size.max() < accepted.size()) {
            throw new SemanticException(new SemanticNotification(SemanticNotification.Level.ERROR, "reject.much.types.in.context", element, Arrays.asList(size.max(), String.join((CharSequence)", ", requireTypes))));
        }
    }

    @Override
    public String type() {
        return "";
    }

    @Override
    public NodeRule compositionRule() {
        return this.rules.stream().filter(r -> r instanceof NodeRule).findFirst().orElse(null);
    }

    @Override
    public List<Rule> rules() {
        return this.rules;
    }

    @Override
    public List<Tag> annotations() {
        HashSet tags = new HashSet();
        this.constraints.forEach(c -> tags.addAll(c.annotations()));
        return new ArrayList<Tag>(tags);
    }

    private List<Mogram> filterByType(MogramContainer node, Constraint.Component constraint) {
        return node.components().stream().filter(component -> OneOf.areCompatibles(component, constraint.type())).collect(Collectors.toList());
    }

    private static boolean areCompatibles(Mogram mogram, String type) {
        for (String nodeType : mogram.types()) {
            if (nodeType == null || !nodeType.equals(type)) continue;
            return true;
        }
        return OneOf.checkFacets(mogram, type);
    }

    private static boolean checkFacets(Mogram mogram, String type) {
        for (Facet facet : mogram.appliedFacets()) {
            if (!facet.type().equals(Resolver.shortType(type))) continue;
            return true;
        }
        return false;
    }

    private List<Mogram> acceptedComponents(List<Mogram> components) {
        return components.stream().filter(component -> this.rules.stream().allMatch(r -> this.accept((Rule)r, components, (Mogram)component))).collect(Collectors.toList());
    }

    private List<Mogram> notAccepted(List<Mogram> components, List<Mogram> accepted) {
        return components.stream().filter(c -> !accepted.contains(c)).collect(Collectors.toList());
    }

    private boolean accept(Rule r, List<Mogram> components, Mogram component) {
        return r instanceof Size ? r.accept(components) : r.accept(component);
    }

    private void error(Mogram notAccepted) throws SemanticException {
        for (Rule rule : this.rules) {
            if (this.accept(rule, notAccepted.container().components(), notAccepted)) continue;
            throw new SemanticException(new SemanticNotification(SemanticNotification.Level.ERROR, rule.errorMessage(), notAccepted, rule.errorParameters()));
        }
    }

    @Override
    public List<Constraint.Component> components() {
        return this.constraints;
    }

    public String toString() {
        List types = this.constraints.stream().map(Constraint.Component::type).collect(Collectors.toList());
        return "OneOf{" + String.join((CharSequence)", ", types) + "}";
    }
}

