/*
 * Decompiled with CFR 0.152.
 */
package io.intino.tara.language.model.rules.variable;

import io.intino.tara.language.model.rules.variable.VariableRule;
import io.intino.tara.language.semantics.errorcollector.SemanticNotification;
import java.io.File;
import java.util.Collections;
import java.util.List;

public class FileRule
implements VariableRule<List<File>> {
    private String message;
    private final List<String> extensions;

    public FileRule(List<String> extensions) {
        this.extensions = extensions;
    }

    @Override
    public boolean accept(List<File> value, String metric) {
        return this.accept(value);
    }

    @Override
    public boolean accept(List<File> values) {
        if (!(values.get(0) instanceof File)) {
            return true;
        }
        for (File file : values) {
            if (file == null) continue;
            if (!file.exists()) {
                this.message = "reject.file.parameter.not.exists";
                return false;
            }
            for (String extension : this.extensions) {
                if (!file.getName().endsWith("." + extension)) continue;
                return true;
            }
            this.message = "reject.file.parameter.with.unavailable.extension";
            return false;
        }
        return true;
    }

    public List<String> getAllowedExtensions() {
        return this.extensions;
    }

    @Override
    public String errorMessage() {
        return this.message;
    }

    @Override
    public List<Object> errorParameters() {
        return Collections.singletonList(String.join((CharSequence)", ", this.extensions));
    }

    @Override
    public SemanticNotification.Level level() {
        return this.message != null && this.message.equals("reject.file.parameter.not.exists") ? SemanticNotification.Level.WARNING : SemanticNotification.Level.ERROR;
    }
}

