/*
 * Decompiled with CFR 0.152.
 */
package io.intino.tara;

import io.intino.tara.Language;
import io.intino.tara.Resolver;
import io.intino.tara.language.model.Element;
import io.intino.tara.language.model.Mogram;
import io.intino.tara.language.semantics.Assumption;
import io.intino.tara.language.semantics.Constraint;
import io.intino.tara.language.semantics.constraints.FacetConstraint;
import io.intino.tara.language.semantics.errorcollector.SemanticException;
import io.intino.tara.language.semantics.errorcollector.SemanticFatalException;
import io.intino.tara.language.semantics.errorcollector.SemanticNotification;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;

public class Checker {
    private final Resolver resolver;
    private final Language language;
    private final List<SemanticException> exceptions = new ArrayList<SemanticException>();

    public Checker(Language language) {
        this.language = language;
        this.resolver = new Resolver(language);
    }

    public void check(Mogram mogram) throws SemanticFatalException {
        this.exceptions.clear();
        this.resolver.resolve(mogram);
        this.checkConstraints(mogram);
        if (!this.exceptions.isEmpty()) {
            this.recoverErrors();
            if (!this.exceptions.isEmpty()) {
                throw new SemanticFatalException(this.exceptions);
            }
        }
    }

    private void recoverErrors() {
        List toRemove = this.exceptions.stream().filter(e -> e.getNotification().key().equals("required.parameter.in.context") && this.isParameterNotFoundRecoverable(e.getNotification().origin()[0], e.getNotification().parameters().get(0).toString(), e.getNotification().parameters().get(1).toString())).collect(Collectors.toList());
        this.exceptions.removeAll(toRemove);
    }

    private boolean isParameterNotFoundRecoverable(Element element, String name, String type) {
        Mogram mogram = (Mogram)element;
        if (this.language == null || mogram == null || mogram.type() == null) {
            return false;
        }
        List facets = this.language.constraints(mogram.type()).stream().filter(c -> this.sameFacet(mogram, (Constraint)c)).map(c -> (Constraint.Facet)c).collect(Collectors.toList());
        for (Constraint.Facet facet : facets) {
            for (Constraint.Parameter c2 : facet.constraints().stream().filter(c -> c instanceof Constraint.Parameter).map(p -> (Constraint.Parameter)p).collect(Collectors.toList())) {
                if (!c2.type().name().equalsIgnoreCase(type) || !c2.name().equals(name) || c2.size().isRequired()) continue;
                return true;
            }
        }
        return false;
    }

    private boolean sameFacet(Mogram mogram, Constraint c) {
        return c instanceof Constraint.Facet && FacetConstraint.findFacet(mogram, ((Constraint.Facet)c).type()) != null;
    }

    private void checkConstraints(Mogram mogram) throws SemanticFatalException {
        if (mogram == null) {
            throw new SemanticFatalException(new SemanticNotification(SemanticNotification.Level.ERROR, "Node is null", (Element)null));
        }
        this.assume(mogram);
        this.checkNodeConstrains(mogram);
    }

    private void assume(Mogram mogram) {
        if (mogram == null || mogram.type() == null || this.language == null) {
            return;
        }
        List<Assumption> assumptions = this.language.assumptions(mogram.type());
        if (assumptions != null) {
            this.assume(mogram, assumptions);
        }
        for (String type : mogram.secondaryTypes()) {
            assumptions = this.language.assumptions(type);
            if (assumptions == null) continue;
            this.assume(mogram, assumptions);
        }
    }

    private void assume(Mogram mogram, Collection<Assumption> assumptions) {
        for (Assumption assumption : assumptions) {
            assumption.assume(mogram);
        }
    }

    private void checkNodeConstrains(Mogram mogram) throws SemanticFatalException {
        List<Constraint> constraints = this.language.constraints(mogram.type());
        if (constraints == null) {
            this.finish(mogram);
        } else {
            for (Constraint constraint : constraints) {
                try {
                    constraint.check(mogram);
                }
                catch (SemanticException e) {
                    if (e.level() == SemanticNotification.Level.ERROR && e.isFatal()) {
                        throw new SemanticFatalException(Collections.singletonList(e));
                    }
                    this.exceptions.add(e);
                }
            }
        }
    }

    private void finish(Mogram mogram) throws SemanticFatalException {
        if (!mogram.isReference()) {
            throw new SemanticFatalException(new SemanticNotification(SemanticNotification.Level.ERROR, "reject.type.not.exists", mogram, Collections.singletonList(this.presentableType(mogram.type()))));
        }
    }

    private String presentableType(String type) {
        return type.replaceFirst(":", " on ");
    }
}

