package io.intino.sumus.reporting.insights;

import io.intino.sumus.reporting.Dashboard;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class ListInsight extends AbstractInsight {

	public ListInsight(Dashboard.Insight insight) {
		super(insight);
	}

	public List<String> attributes() {
		if (isNotList()) return Collections.emptyList();
		String data = options().get("attributes");
		if (data == null || data.isEmpty()) return Collections.emptyList();
		return Arrays.stream(data.split(",")).map(String::trim).collect(Collectors.toList());
	}

	public Map<String, String> prefixes() {
		if (isNotList()) return Collections.emptyMap();
		String data = options().get("prefixes");
		if (data == null || data.isEmpty()) return Collections.emptyMap();
		return Arrays.stream(data.split(","))
				.filter(a -> a.contains(":"))
				.map(d -> d.trim().split(":", -1))
				.collect(Collectors.toMap(d -> d[0], d -> d[1], (a, b) -> b));
	}

	private boolean isNotList() {
		return insight.type() != Type.List;
	}
}
