package io.intino.sumus.reporting.insights;

import io.intino.alexandria.Timetag;
import io.intino.sumus.reporting.Dashboard;
import io.intino.sumus.reporting.Node;
import io.intino.sumus.reporting.model.Order;
import io.intino.sumus.reporting.model.Visibility;

import java.util.Map;

public abstract class AbstractInsight implements Dashboard.Insight {

	protected final Dashboard.Insight insight;

	public AbstractInsight(Dashboard.Insight insight) {
		this.insight = insight;
	}

	@Override
	public String id() {
		return insight.id();
	}

	@Override
	public String label() {
		return insight.label();
	}

	@Override
	public Type type() {
		return insight.type();
	}

	@Override
	public String ledger() {
		return insight.ledger();
	}

	@Override
	public String[] dimensions() {
		return insight.dimensions();
	}

	@Override
	public String[] filters(Timetag timetag) {
		return insight.filters(timetag);
	}

	@Override
	public String[] dateFilters(Timetag timetag) {
		return insight.dateFilters(timetag);
	}

	@Override
	public String[] indicators() {
		return insight.indicators();
	}

	@Override
	public Integer level() {
		return insight.level();
	}

	@Override
	public Map<String, String> options() {
		return insight.options();
	}

	@Override
	public Map<String, String> labels() {
		return insight.labels();
	}

	@Override
	public Visibility visibility() {
		return insight.visibility();
	}

	@Override
	public Order order() {
		return insight.order();
	}

	@Override
	public String[] slices() {
		return insight.slices();
	}

	@Override
	public Map<String, String> formats() {
		return insight.formats();
	}

	@Override
	public Node.Type node() {
		return insight.node();
	}

	@Override
	public Integer maxItems() {
		return insight.maxItems();
	}
}
