package io.intino.sumus.reporting.helpers;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;

public class ZipHelper {

	public static void zipAndRemove(File folder) {
		if (!folder.exists()) return;
		try {
			zip(folder);
			removeRecursively(folder);
		} catch (IOException e) {
			e.printStackTrace();
		}
	}

	public static void zip(File folder) {
		File zip = new File(folder.getParentFile(), folder.getName() + ".zip");
		zip(zip, folder);
	}

	public static void zip(File zip, File... files) {
		try {
			if (zip.exists()) zip.delete();
			write(zip, entries(files));
		} catch (IOException e) {
			e.printStackTrace();
		}
	}

	private static void write(File file, Map<String, String> entries) throws IOException {
		if (entries.isEmpty()) return;
		try (ZipOutputStream zos = new ZipOutputStream(new FileOutputStream(file))) {
			entries.forEach((name, content) -> {
				try {
					zos.putNextEntry(new ZipEntry(name));
					zos.write(content.getBytes());
					zos.closeEntry();
				} catch (IOException e) {
					e.printStackTrace();
				}
			});
		}
	}

	private static Map<String, String> entries(File... files) {
		Map<String, String> entries = new HashMap<>();
		Arrays.stream(files).forEach(f -> addEntry(entries, f, f.getName()));
		return entries;
	}

	private static void addEntry(Map<String, String> entries, File file, String entry) {
		if (file.isDirectory()) {
			for (File subFile : file.listFiles()) {
				addEntry(entries, subFile, entry + "/" + subFile.getName());
			}
		} else if (file.exists() && file.length() > 0) {
			entries.put(entry, content(file));
		}
	}

	private static String content(File file) {
		try {
			return Files.readString(file.toPath());
		} catch (Throwable e) {
			return "";
		}
	}

	private static void removeRecursively(File file) throws IOException {
		if (!file.exists()) return;
		if (file.isFile()) file.delete();
		else Files.walk(file.toPath()).sorted(Comparator.reverseOrder()).map(Path::toFile).forEach(File::delete);
	}

}
