package io.intino.sumus.reporting.builders.templates;

import io.intino.itrules.Template;
import io.intino.sumus.reporting.builders.schemas.*;
import io.intino.sumus.reporting.builders.schemas.views.ViewChart;
import io.intino.sumus.reporting.builders.schemas.views.ViewConfig;

import java.text.NumberFormat;
import java.util.Locale;

public class Renderer {

    static final String TranslationMark = "::";
    static final NumberFormat GermanNumberFormat = NumberFormat.getNumberInstance(Locale.GERMAN);

    public static String render(Object object) {
        if (object instanceof TimeNavigator) return render(new TimeNavigatorTemplate(), object);
        if (object instanceof TableBar) return render(new TableBarTemplate(), object);
        if (object instanceof Table) return render(new TableTemplate(), object);
        if (object instanceof ColumnChart) return render(new ColumnTemplate(), object);
        if (object instanceof PieChart) return render(new PieTemplate(), object);
        if (object instanceof GaugeChart) return render(new GaugeTemplate(), object);
        if (object instanceof HtmlEmbedChart) return render(new HtmlTemplate(), object);
        if (object instanceof MicrositeAction || object instanceof MicrositeLink) return render(new MicrositeTemplate(), object);
        if (object instanceof List) return render(new ListTemplate(), object);
        if (object instanceof ViewChart ||
                object instanceof ViewChart.Select ||
                object instanceof ViewChart.Function ||
                object instanceof ViewChart.ViewDate ||
                object instanceof ViewConfig ||
                object instanceof ViewConfig.ViewLabels ||
                object instanceof ViewConfig.ViewPlotLine) return render(new ViewTemplate(), object);
        return "";
    }

    public static String render(Template template, Object object) {
        return template
                .add("Escaped", v -> "'" + v + "'")
                .add("Translated", Renderer::Translate)
                .add("GermanFormat", Renderer::GermanFormat)
                .render(object);
    }

    private static Object Translate(Object object) {
        if (!(object instanceof String)) return object;

        String value = ((String) object).replace(":", "");
        return TranslationMark + value + TranslationMark;
    }

    private static Object GermanFormat(Object object) {
        if (object instanceof Double || object instanceof Integer || object instanceof Long) return GermanNumberFormat.format(object);
        return object;
    }
}
