package io.intino.sumus.reporting.builders.schemas;

import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;

public class TableBar extends Table {

    final List<String> barAttributes;

    List<RowBar> rows = Collections.emptyList();
    double maxLength = 0;

    public TableBar(String id, String title, List<Attribute> attributes, List<String> barAttributes) {
        super(id, title, attributes);
        this.barAttributes = barAttributes;
    }

    public Table rows(List<Row> rows) throws TableChartException {
        for (Row row : rows) checkSizes(row);
        this.maxLength = maxLength(rows);
        this.rows = rows.stream()
                .map(r -> new RowBar(r, barsOf(r)))
                .collect(Collectors.toList());
        return this;
    }

    private Double maxLength(List<Row> rows) {
        double maxLenght = 0;
        for (Row row : rows) {
            double rowLength = barAttributes.stream()
                    .map(a -> valueOf(row, a))
                    .filter(Objects::nonNull)
                    .mapToDouble(v -> v)
                    .sum();
            if (rowLength > maxLenght) maxLenght = rowLength;
        }
        return maxLenght;
    }

    private Double valueOf(Row row, String indicator) {
        Attribute attribute = attributeOf(indicator);
        if (attribute == null) return null;

        Cell cell = row.cells.get(attribute.index());
        if (cell == null) return null;

        Object value = cell.value();
        return value instanceof Double ? (double) value : null;
    }

    private Attribute attributeOf(String id) {
        return attributes.stream().filter(a -> a.id().equalsIgnoreCase(id)).findFirst().orElse(null);
    }

    private List<RowBar.Bar> barsOf(Row row) {
        return barAttributes.stream()
                .map(indicator -> {
                    Double value = valueOf(row, indicator);
                    if (value == null) return null;

                    double width = maxLength != 0 ? ((value * 100) / maxLength) : 0;
                    return new RowBar.Bar(indicator, width);
                })
                .filter(Objects::nonNull)
                .collect(Collectors.toList());
    }

    private static class RowBar extends Row {

        List<Bar> bars;

        public RowBar(Row row, List<Bar> bars) {
            super(row.name);
            this.cells = row.cells;
            this.onMicrosite = row.onMicrosite;
            this.onClick = row.onClick;
            this.bars = bars;
        }

        private static class Bar {
            String name;
            double width;

            public Bar(String name, double width) {
                this.name = name;
                this.width = width;
            }
        }
    }
}
