package io.intino.sumus.reporting.builders.schemas;

import io.intino.sumus.reporting.model.Order;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.Objects;
import java.util.stream.Collectors;

public class List {

    private final String id;
    private java.util.List<Item> items = new ArrayList<>();

    public List(String id) {
        this.id = id;
    }

    public List add(Item... items) {
        for (Item item : items) {
            if (this.items.contains(item)) continue;
            this.items.add(item);
        }
        return this;
    }

    public List sortBy(Order order) {
        if (order == null || order.indicator() == null) return this;
        this.items = items.stream().sorted(sort(order)).collect(Collectors.toList());
        return this;
    }

    private Comparator<Item> sort(Order order) {
        return (i1, i2) -> {
            String value1 = i1.value(order.indicator());
            String value2 = i2.value(order.indicator());
            return order.is(Order.Type.Descending) ?
                    value2.compareTo(value1) :
                    value1.compareTo(value2);
        };
    }

    public static class Item {
        java.util.List<Attribute> attributes = new LinkedList<>();

        public Item add(String name, String value) {
            attributes.add(new Attribute(name, value));
            return this;
        }

        public Item add(String name, String value, String prefix) {
            attributes.add(new Attribute(name, value).prefix(prefix));
            return this;
        }

        public String value(String attribute) {
            return attributes.stream()
                    .filter(a -> a.name.equalsIgnoreCase(attribute))
                    .findFirst().map(a -> a.value).orElse("");
        }

        public boolean isEmpty() {
            return attributes.isEmpty();
        }

        @Override
        public boolean equals(Object object) {
            if (this == object) return true;
            if (!(object instanceof Item)) return false;
            return Objects.equals(attributes, ((Item) object).attributes);
        }

        @Override
        public int hashCode() {
            return Objects.hash(attributes);
        }

        static class Attribute {
            private final String name;
            private final String value;
            private String prefix;

            public Attribute(String name, String value) {
                this.name = name;
                this.value = value;
            }

            public Attribute prefix(String prefix) {
                this.prefix = prefix;
                return this;
            }

            @Override
            public boolean equals(Object object) {
                if (this == object) return true;
                if (!(object instanceof Attribute)) return false;
                Attribute attribute = (Attribute) object;
                return Objects.equals(name, attribute.name) && Objects.equals(value, attribute.value);
            }

            @Override
            public int hashCode() {
                return Objects.hash(name, value);
            }
        }
    }
}
