package io.intino.sumus.reporting.builders.schemas;

public class GaugeChart {
    private final String id;
    private final String title;
    private double value;
    private String state;
    private String onClick;

    public GaugeChart(String id, String title) {
        this.id = id;
        this.title = title;
    }

    public GaugeChart value(double value) {
        this.value = value;
        this.state = barState(value);
        return this;
    }

    public GaugeChart onClick(String onClick) {
        this.onClick = onClick;
        return this;
    }

    private static String barState(double value) {
        if (value < 0) return "unknown";
        if (value < 25) return "low";
        if (value < 50) return "mid-low";
        return value < 75 ? "mid-high" : "high";
    }
}
