package io.intino.sumus.reporting.builders;

import io.intino.alexandria.Timetag;
import io.intino.sumus.reporting.builders.schemas.TimeNavigator;
import io.intino.sumus.reporting.builders.templates.Renderer;
import io.intino.sumus.reporting.model.Scale;

import java.time.LocalDate;

import static io.intino.sumus.reporting.model.Scale.*;

public class TimeNavigatorBuilder {

	public String build(Timetag timetag, Scale scale) {
		LocalDate date = timetag.datetime().toLocalDate();
		TimeNavigator chart = new TimeNavigator(
				scale.format(date),
				new Timetag(previous(date, scale), timetag.scale()),
				new Timetag(next(date, scale), timetag.scale())
		);
		return Renderer.render(chart);
	}

	private LocalDate next(LocalDate date, Scale scale) {
		LocalDate scaleStart = scale.startDate(date);
		if (scale == Week) return scale.endDate(scaleStart.plusWeeks(1));
		if (scale == Month) return scale.endDate(scaleStart.plusMonths(1));
		if (scale == Quarter) return scale.endDate(scaleStart.plusMonths(3));
		if (scale == Year) return scale.endDate(scaleStart.plusYears(1));
		return scaleStart.plusDays(1);
	}

	private LocalDate previous(LocalDate date, Scale scale) {
		LocalDate scaleStart = scale.startDate(date);
		if (scale == Week) return scale.endDate(scaleStart.minusWeeks(1));
		if (scale == Month) return scale.endDate(scaleStart.minusMonths(1));
		if (scale == Quarter) return scale.endDate(scaleStart.minusMonths(3));
		if (scale == Year) return scale.endDate(scaleStart.minusYears(1));
		return scaleStart.minusDays(1);
	}
}
