package io.intino.sumus.reporting.builders;

import io.intino.sumus.reporting.Dashboard.Report;
import io.intino.sumus.reporting.Node;
import io.intino.sumus.reporting.model.Visibility;

import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;

import static io.intino.sumus.reporting.helpers.FormatHelper.translationMark;

public class NavigationBuilder {

	private final Report report;
	private final Visibility visibility;

	public NavigationBuilder(Report report) {
		this.report = report;
		this.visibility = report.visibility();
	}

	public String build(Node node) {
		return "<aside class=\"top-info\">" + navTag(node) + "</aside>";
	}

	private String navTag(Node node) {
		return "<div style=\"display: flex;align-items: center;\">" +
				"<h3 style=\"display: flex;align-items: center;\" class=\"MuiTypography-root MuiTypography-h3 ReportingTypo ReportingTypo-h3\">" +
				reportNameTag(node) + ". " + reportDescriptionTag() + navigationTag(node) + selectTag(node) +
				"</h3>" +
				"</div>";
	}

	private String reportNameTag(Node node) {
		return node.isMain() ?
				translationMark(report.label()) :
				"<a onclick=\"" + openNodeAction(Node.GlobalNode) + "\" class=\"admin\">" + translationMark(report.label()) + "</a>";
	}

	private String reportDescriptionTag() {
		String description = report.description();
		return description != null && !description.isEmpty() ? "<button class=\"description-icon\" title=\"" + translationMark(description) + "\"></button>" : "";
	}

	private String navigationTag(Node node) {
		if (node.name().isEmpty()) return "";
		String parent = node.parent() != null ? node.parent().name() : "";
		String name = node.name().replace(parent, "");
		return "<a class=\"navigation-node\" onclick=\"" + openNodeAction(parent) + "\">" + parent + "</a>" + name;
	}

	private String selectTag(Node node) {
		if (areChildrenNotVisible(node)) return "";
		return "<select onchange=\"" + openNodeActionRaw("this.value") + "\">" +
				"<option value='' selected></option>" + optionTags(node.children()) + "</select>";
	}

	private boolean areChildrenNotVisible(Node node) {
		return node.children().isEmpty() || node.children().stream().noneMatch(visibility::isVisible);
	}

	private String optionTags(List<Node> nodes) {
		return nodes.stream()
				.filter(n -> !n.name().isEmpty())
				.sorted(Comparator.comparing(Node::name))
				.map(this::optionTag)
				.collect(Collectors.joining(""));
	}

	private String optionTag(Node node) {
		String parent = node.parent() != null ? node.parent().name() + "." : "";
		String subName = node.name().replace(parent, "");
		return "<option value='" + node.name() + "'>" + subName + "</option>";
	}

	private String openNodeAction(String name) {
		return openNodeActionRaw("'" + name + "'");
	}

	private String openNodeActionRaw(String name) {
		return "javascript:openNode(" + name + ")";
	}

}
