package io.intino.sumus.reporting.builders;

import io.intino.sumus.engine.Cube;
import io.intino.sumus.reporting.Dashboard.Insight;
import io.intino.sumus.reporting.Node;
import io.intino.sumus.reporting.builders.schemas.MicrositeLink;
import io.intino.sumus.reporting.builders.templates.Renderer;


public class MicrositeBuilder implements UIBuilder {

	private final Insight insight;
	private final MicrositeActionBuilder microsite;

	public MicrositeBuilder(Insight insight, MicrositeActionBuilder microsite) {
		this.insight = insight;
		this.microsite = microsite;
	}

	@Override
	public String build(Cube cube, Node node) {
		MicrositeLink microsite = new MicrositeLink(insight.label(), this.microsite.action(node));
		return Renderer.render(microsite);
	}
}
