package io.intino.sumus.reporting.builders;

import io.intino.sumus.engine.Cube;
import io.intino.sumus.engine.Fact;
import io.intino.sumus.engine.dimensions.Category;
import io.intino.sumus.reporting.Dashboard.Insight;
import io.intino.sumus.reporting.Node;
import io.intino.sumus.reporting.builders.schemas.List;
import io.intino.sumus.reporting.builders.schemas.List.Item;
import io.intino.sumus.reporting.builders.templates.Renderer;
import io.intino.sumus.reporting.helpers.FormatHelper;
import io.intino.sumus.reporting.insights.ListInsight;

import java.util.Map;

public class ListBuilder implements UIBuilder {

    private final ListInsight insight;
    private final Map<String, String> prefixes;

    public ListBuilder(Insight insight) {
        this.insight = new ListInsight(insight);
        this.prefixes = this.insight.prefixes();
    }

    @Override
    public String build(Cube cube, Node node) {
        List list = new List(insight.id());
        for (Fact fact : cube.facts()) {
            Item item = item(fact);
            if (!item.isEmpty()) list.add(item);
        }
        list.sortBy(insight.order());
        return Renderer.render(list);
    }

    private Item item(Fact fact) {
        Item item = new Item();
        for (String attribute : insight.attributes()) {
            Object object = fact.value(attribute);
            if (object == null) continue;
            item.add(attribute, valueOf(object), prefix(attribute));
        }
        return item;
    }

    private String valueOf(Object object) {
        if (object instanceof Category) return  ((Category) object).label;
        return object + "";
    }

    private String prefix(String attribute) {
        String prefix = prefixes.get(attribute);
        return prefix != null ? FormatHelper.translationMark(prefix) + " " : "";
    }
}
