package io.intino.sumus.reporting;

import java.util.List;

public interface Node {
    String GlobalNode = "_All";

    String id();
    String name();
    String dimension();
    Node parent();
    List<Node> children();
    default String filter() {
        return dimension() + ":" + name();
    }
    default boolean isRoot() {
        return parent() == null;
    }
    default boolean isMain() {
        return id().equals(GlobalNode);
    }
    default boolean isLeave() {
        return children().isEmpty();
    }

    enum Type {
        Global, Root, Leave, Other
    }
}
