package io.intino.sumus.reporting;

import io.intino.alexandria.Timetag;
import io.intino.sumus.reporting.model.*;

import java.io.File;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;

public interface Dashboard {
	String name();
	String navigation();
	File datamart();
	Set<String> nodes();
	List<Report> reports();
	boolean isRealtime();

	default String template() {
		return "";
	}
	default Report report(String name) {
		return reports().stream().filter(r -> r.name().equalsIgnoreCase(name)).findFirst().orElse(null);
	}

	interface Report {
		String name();
		String label();
		String group();
		String description();
		String template();
		Set<String> ledgers();
		List<View> views();
		List<Insight> insights();
		List<Storyboard> storyboards();
		List<CustomIndicator> customIndicators();
		List<Scale> scales();
		Map<String, Formatter> formatters();
		Visibility visibility();
		String[] filters();
		boolean requireAllLedgers();
		boolean isSingleton();
		boolean isRealtime();

		default Locale locale() {
			return Locale.GERMAN;
		}
		default Formatter formatter(String name) { return formatters().getOrDefault(name, new Formatter(locale())); }
	}

	interface View {
		String name();
		String label();
		String ledger();
		String[] dimensions();
		String[] filters(Timetag timetag);
		String[] dateFilters(Timetag timetag);
		String[] indicators();
		Integer level();

		default Period period() {
			return new Period(Scale.Day);
		}
	}

	interface Insight {
		String id();
		String label();
		Type type();
		String ledger();
		String[] dimensions();
		String[] filters(Timetag timetag);
		String[] dateFilters(Timetag timetag);
		String[] indicators();
		String[] slices();
		Integer level();
		Visibility visibility();
		Order order();
		Integer maxItems();
		Map<String, String> options();
		Node.Type node();

		Map<String, String> labels();
		default String translate(String label) {
			return labels().getOrDefault(label, label);
		}

		Map<String, String> formats();
		default String format(String indicator) {
			return formats().get(indicator);
		}

		enum Type {
			Table, TableBar, Pie, Gauge, Column, StackedColumn, Microsite, Json, Html, List,
			TableView, LineView, HeatmapView, ColumnView, ColumnSwapView
		}
	}
}
