/*
 * Decompiled with CFR 0.152.
 */
package io.intino.sumus.reporting.loaders;

import io.intino.alexandria.Timetag;
import io.intino.alexandria.logger.Logger;
import io.intino.sumus.engine.Ledger;
import io.intino.sumus.engine.LedgerDecorator;
import io.intino.sumus.engine.ledgers.EmptyLedger;
import io.intino.sumus.engine.ledgers.columnar.ColumnarLedger;
import io.intino.sumus.engine.ledgers.columnar.ColumnarLedgerDecorator;
import io.intino.sumus.engine.ledgers.composite.CompositeLedger;
import io.intino.sumus.model.LedgerDefinition;
import io.intino.sumus.reporting.loaders.LedgerAggregator;
import io.intino.sumus.reporting.model.Period;
import io.intino.sumus.reporting.model.Scale;
import java.io.File;
import java.io.IOException;
import java.text.ParseException;
import java.util.HashMap;
import java.util.Map;

public class LedgerLoader {
    private final File folder;
    private final LedgerDecorator<ColumnarLedger> decorator;
    private final LedgerAggregator aggregator;

    public LedgerLoader(File folder) {
        this.folder = folder;
        this.decorator = new ColumnarLedgerDecorator(folder);
        this.aggregator = new LedgerAggregator(folder);
    }

    public synchronized Ledger ledger(String name, Scale scale, Timetag timetag) {
        return this.ledger(name, new Period(scale), timetag);
    }

    public synchronized Ledger ledger(String name, Period period, Timetag timetag) {
        return this.ledger(name, (Timetag[])period.timetags(timetag).toArray(Timetag[]::new));
    }

    public synchronized Ledger ledger(String name, Timetag ... timetags) {
        try {
            return this.loadLedger(name, timetags);
        }
        catch (LedgerNotFoundException e) {
            return new EmptyLedger();
        }
        catch (Throwable e) {
            Logger.warn((String)("Error loading ledger: " + name));
            return new EmptyLedger();
        }
    }

    private Ledger loadLedger(String name, Timetag ... timetags) throws IOException, LedgerNotFoundException, ParseException {
        Map<Timetag, Ledger> ledgers = this.loadLedgers(name, timetags);
        if (ledgers.isEmpty()) {
            throw new LedgerNotFoundException();
        }
        if (ledgers.size() == 1) {
            return ledgers.values().stream().findFirst().orElseThrow(LedgerNotFoundException::new);
        }
        CompositeLedger composite = new CompositeLedger("date");
        ledgers.forEach((timetag, ledger) -> composite.add(ledger, timetag));
        return composite;
    }

    private Map<Timetag, Ledger> loadLedgers(String name, Timetag ... timetags) throws IOException, ParseException {
        LedgerDefinition definition = this.definition(name);
        HashMap<Timetag, Ledger> ledgers = new HashMap<Timetag, Ledger>();
        for (Timetag timtag : timetags) {
            Ledger ledger = this.loadLedger(name, definition, timtag);
            if (ledger == null) continue;
            ledgers.put(timtag, ledger);
        }
        return ledgers;
    }

    private Ledger loadLedger(String name, LedgerDefinition definition, Timetag timetag) throws IOException {
        File file = this.ledgerFile(name, timetag);
        if (file.exists()) {
            return this.ledger(definition, file);
        }
        if (LedgerAggregator.isAggregable(definition)) {
            return this.aggregatedLedger(name, definition, timetag);
        }
        return null;
    }

    private Ledger aggregatedLedger(String name, LedgerDefinition definition, Timetag timetag) {
        try {
            String[][] content = this.aggregator.aggregate(name, definition, timetag);
            return this.ledger(definition, content);
        }
        catch (Throwable e) {
            Logger.error((Throwable)e);
            return null;
        }
    }

    private Ledger ledger(LedgerDefinition definition, File file) throws IOException {
        return this.decorator.decorate((Ledger)new ColumnarLedger(definition).load(file, "\t"));
    }

    private Ledger ledger(LedgerDefinition definition, String[][] content) {
        return this.decorator.decorate((Ledger)new ColumnarLedger(definition).load(content));
    }

    private LedgerDefinition definition(String type) throws ParseException {
        return LedgerDefinition.load((File)this.folder, (File)new File(this.folder, type + ".ledger"));
    }

    private File ledgerFile(String type, Timetag timetag) {
        return new File(this.folder, type + "/" + timetag + ".tsv");
    }

    public static class LedgerNotFoundException
    extends Exception {
    }
}

