/*
 * Decompiled with CFR 0.152.
 */
package io.intino.sumus.reporting.builders;

import io.intino.alexandria.Timetag;
import io.intino.sumus.reporting.Dashboard;
import io.intino.sumus.reporting.Node;
import io.intino.sumus.reporting.builders.UIBuilder;
import io.intino.sumus.reporting.builders.schemas.views.ViewChart;
import io.intino.sumus.reporting.builders.schemas.views.ViewConfig;
import io.intino.sumus.reporting.insights.TimelineInsight;
import io.intino.sumus.reporting.model.Period;
import io.intino.sumus.reporting.model.Scale;
import java.time.LocalDate;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.stream.Collectors;

public abstract class ViewBuilder
implements UIBuilder {
    protected final TimelineInsight insight;
    protected final Timetag timetag;
    protected final String report;
    protected String chartID;

    public ViewBuilder(Dashboard.Report report, Dashboard.Insight insight, Timetag timetag) {
        this.insight = new TimelineInsight(insight);
        this.timetag = timetag;
        this.report = report.name();
        this.chartID = insight.id() + "-chart";
    }

    protected ViewChart.Function functionOf(String functionCall, Node node) {
        return new ViewChart.Function(functionCall, this.chartID, this.insight.label()).config(this.config(node)).dates(this.dates());
    }

    private ViewConfig config(Node node) {
        return new ViewConfig(this.report, this.insight.ledger(), this.insight.view()).indicators(List.of(this.insight.indicators())).dimension(this.insight.drillDimension()).dimension2(this.insight.filterDimension()).nodeDimension(node.dimension()).node(node.name()).nodeID(node.id()).filters(List.of(this.insight.filters(this.timetag))).slices(List.of(this.insight.slices())).viewFilters(List.of(this.insight.viewFilter())).dateFilters(List.of(this.insight.dateFilters(this.timetag))).plotLines(this.plotLines()).labels(this.labels()).isNav(this.isNavigable(node)).showDataLabels(this.insight.showDataLabels());
    }

    private List<ViewChart.ViewDate> dates() {
        Period period = this.insight.period();
        Period timeUnit = this.insight.timeUnit();
        return this.dates(period, timeUnit).stream().map(date -> ViewBuilder.viewDateOf(timeUnit, date)).collect(Collectors.toList());
    }

    private List<LocalDate> dates(Period period, Period timeUnit) {
        HashSet<String> cache = new HashSet<String>();
        LinkedList<LocalDate> uniques = new LinkedList<LocalDate>();
        List<LocalDate> dates = period.isSingle() ? this.naturalDates(period) : period.dates(this.timetag);
        for (LocalDate date : dates) {
            String timetag = timeUnit.scale().timetag(date);
            if (cache.contains(timetag)) continue;
            cache.add(timetag);
            uniques.add(date);
        }
        return uniques;
    }

    private static ViewChart.ViewDate viewDateOf(Period timeUnit, LocalDate date) {
        Scale timeUnitScale = timeUnit.scale();
        return new ViewChart.ViewDate(timeUnitScale.timetag(date), timeUnitScale.label(date), timeUnitScale.format(date), Scale.Day.timetag(timeUnit.onlyLast() ? timeUnitScale.endDate(date) : timeUnitScale.startDate(date)), Scale.Day.timetag(timeUnitScale.endDate(date)));
    }

    private List<LocalDate> naturalDates(Period period) {
        Scale scale = period.scale();
        LocalDate start = scale.startDate(this.timetag);
        LocalDate end = scale.endDate(this.timetag);
        return start.datesUntil(end.plusDays(1L)).collect(Collectors.toList());
    }

    private boolean isNavigable(Node node) {
        return node.dimension() != null && this.insight.navFilterEnabled() && this.insight.dimensions().length == 1 && this.insight.dimensions()[0].equalsIgnoreCase(node.dimension());
    }

    private List<ViewConfig.ViewPlotLine> plotLines() {
        if (this.insight.plotLines() == null) {
            return Collections.emptyList();
        }
        return Arrays.stream(this.insight.plotLines().split(",")).map(line -> line.split(":")).filter(d -> ((String[])d).length >= 1).map(this::plotLine).collect(Collectors.toList());
    }

    private ViewConfig.ViewPlotLine plotLine(String[] data) {
        return new ViewConfig.ViewPlotLine(data[0]).name(data.length > 1 ? data[1] : null).color(data.length > 2 ? data[2] : null);
    }

    private ViewConfig.ViewLabels labels() {
        ViewConfig.ViewLabels labels = new ViewConfig.ViewLabels();
        this.insight.labels().forEach(labels::set);
        return labels;
    }
}

