/*
 * Decompiled with CFR 0.152.
 */
package io.intino.sumus.reporting;

import io.intino.alexandria.Timetag;
import io.intino.alexandria.logger.Logger;
import io.intino.sumus.engine.Cube;
import io.intino.sumus.engine.Dimension;
import io.intino.sumus.engine.Filter;
import io.intino.sumus.engine.Ledger;
import io.intino.sumus.engine.filters.CompositeFilter;
import io.intino.sumus.engine.filters.SliceFilter;
import io.intino.sumus.engine.ledgers.EmptyLedger;
import io.intino.sumus.reporting.Dashboard;
import io.intino.sumus.reporting.Node;
import io.intino.sumus.reporting.builders.JsonBuilder;
import io.intino.sumus.reporting.builders.NavigationBuilder;
import io.intino.sumus.reporting.builders.TimeNavigatorBuilder;
import io.intino.sumus.reporting.builders.UIBuilder;
import io.intino.sumus.reporting.builders.UIBuilderFactory;
import io.intino.sumus.reporting.helpers.CubesHelper;
import io.intino.sumus.reporting.helpers.FormatHelper;
import io.intino.sumus.reporting.helpers.JsonHelper;
import io.intino.sumus.reporting.helpers.MinifyHelper;
import io.intino.sumus.reporting.helpers.ResourceHelper;
import io.intino.sumus.reporting.helpers.ZipHelper;
import io.intino.sumus.reporting.loaders.LedgerLoader;
import io.intino.sumus.reporting.loaders.NodeLoader;
import io.intino.sumus.reporting.model.Scale;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.StandardOpenOption;
import java.time.DayOfWeek;
import java.time.LocalDate;
import java.time.temporal.TemporalAdjusters;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class DashboardBuilder {
    public static final int MaxLevel = 100;
    private static final String BaseHtml = ResourceHelper.dashboardBaseHtml();
    private final Dashboard dashboard;
    private final File folder;
    private final LedgerLoader ledgerLoader;
    private List<Node> nodes;
    private boolean minify = true;

    public DashboardBuilder(Dashboard dashboard, File folder) {
        this.dashboard = dashboard;
        this.folder = new File(folder, dashboard.name());
        this.folder.mkdirs();
        this.ledgerLoader = new LedgerLoader(dashboard.datamart());
    }

    public Dashboard dashboard() {
        return this.dashboard;
    }

    public List<Node> nodes() {
        if (this.nodes == null) {
            this.nodes = new NodeLoader(this.dashboard.navigation(), this.dashboard.nodes()).nodes();
        }
        return this.nodes;
    }

    public DashboardBuilder minify(boolean minify) {
        this.minify = minify;
        return this;
    }

    public void build(Timetag timetag) {
        this.build(this.reportBuilders(timetag));
    }

    public void build(Dashboard.Report report, Timetag timetag) {
        this.build(this.reportBuilder(report, timetag));
    }

    private void build(ReportBuilder ... builders) {
        Arrays.stream(builders).forEach(b -> b.build(this.folder));
    }

    public void buildViews(Dashboard.Report report, Timetag timetag) {
        this.reportBuilder(report, timetag).buildViews(this.folder);
    }

    public String buildNodeContent(Dashboard.Report report, Timetag timetag, String nodeName) {
        Node node = this.nodeOf(nodeName);
        if (node == null) {
            return null;
        }
        ReportBuilder reportBuilder = this.reportBuilder(report, timetag);
        return reportBuilder.ledgersNotFound() ? null : reportBuilder.bodyOf(node);
    }

    private ReportBuilder[] reportBuilders(Timetag timetag) {
        return (ReportBuilder[])this.dashboard.reports().stream().map(report -> this.reportBuilder((Dashboard.Report)report, timetag)).toArray(ReportBuilder[]::new);
    }

    private ReportBuilder reportBuilder(Dashboard.Report report, Timetag timetag) {
        return new ReportBuilder(report, timetag);
    }

    private Node nodeOf(String name) {
        return this.nodes().stream().filter(n -> n.name().equalsIgnoreCase(name)).findFirst().orElse(null);
    }

    private static String nodeRootName(Node node) {
        return node != null ? node.name().split("\\.")[0] : "";
    }

    protected static boolean notFound(Ledger ledger) {
        return ledger == null || ledger instanceof EmptyLedger;
    }

    private static void save(File file, String content) {
        try {
            file.getParentFile().mkdirs();
            Files.write(file.toPath(), content.getBytes(), StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING);
        }
        catch (IOException e) {
            Logger.error((Throwable)e);
        }
    }

    private class ReportBuilder {
        public final Dashboard.Report report;
        private final Timetag timetag;
        private final Scale scale;
        private final Map<String, Ledger> ledgers;
        private final List<ViewBuilder> viewBuilders;
        private final List<InsightBuilder> insightBuilders;
        private final NavigationBuilder navBuilder;

        public ReportBuilder(Dashboard.Report report, Timetag timetag) {
            this.report = report;
            this.timetag = timetag;
            this.scale = Scale.of(timetag.scale());
            this.ledgers = this.loadLedgers();
            this.viewBuilders = this.loadViewBuilders();
            this.insightBuilders = this.loadInsightBuilders();
            this.navBuilder = new NavigationBuilder(report);
        }

        public void build(File root) {
            this.buildViews(root);
            this.buildReport(root);
        }

        public void buildViews(File root) {
            this.viewBuilders.forEach(builder -> builder.build(root));
        }

        public void buildReport(File root) {
            if (this.ledgersNotFound() || this.isAnyLedgerMissing()) {
                return;
            }
            File reportFolder = this.folder(root);
            DashboardBuilder.this.nodes().stream().filter(this::isVisible).forEach(n -> this.buildReport(reportFolder, (Node)n));
            ZipHelper.zipAndRemove(reportFolder);
        }

        private void buildReport(File folder, Node node) {
            File file = new File(folder, node.id() + ".html");
            DashboardBuilder.save(file, this.bodyOf(node));
        }

        public String bodyOf(Node node) {
            String template = this.template(node);
            for (InsightBuilder b : this.insightBuilders) {
                if (!template.contains(b.mark())) continue;
                template = template.replace(b.mark(), b.build(node));
            }
            String content = this.replaceGenerics(template, node);
            return DashboardBuilder.this.minify ? MinifyHelper.minify(content) : content;
        }

        public File folder(File root) {
            String folderName = this.report.isSingleton() ? this.report.name() : this.scale.timetag(this.timetag.datetime().toLocalDate());
            return new File(root, "reports/" + this.report.name() + "/" + folderName);
        }

        private String template(Node node) {
            return DashboardBuilder.this.dashboard.template() + BaseHtml + this.navBuilder.build(node) + this.reportTemplate();
        }

        private String reportTemplate() {
            String template = this.report.template();
            if (template != null && !template.isEmpty()) {
                return template;
            }
            return this.insightBuilders.stream().map(InsightBuilder::mark).collect(Collectors.joining("\n"));
        }

        private String replaceGenerics(String template, Node node) {
            LocalDate date = this.timetag.datetime().toLocalDate();
            TimeNavigatorBuilder timeNavBuilder = new TimeNavigatorBuilder();
            return template.replace("::CurrentNode::", node.isMain() ? "Global" : node.name()).replace("::CurrentRootNode::", node.isMain() ? "Global" : DashboardBuilder.nodeRootName(node)).replace("::CurrentDayTimetag::", Scale.Day.timetag(date)).replace("::CurrentDay::", Scale.Day.format(date)).replace("::CurrentWeekDay::", Scale.Week.format(date)).replace("::CurrentMonth::", Scale.Month.format(date)).replace("::CurrentQuarter::", Scale.Quarter.format(date)).replace("::CurrentYear::", Scale.Year.format(date)).replace("::PreviousYear::", Scale.Year.format(date.minusYears(1L))).replace("::NextYear::", Scale.Year.format(date.plusYears(1L))).replace("::TimeWidgetDay::", timeNavBuilder.build(this.timetag, Scale.Day)).replace("::TimeWidgetWeek::", timeNavBuilder.build(this.timetag, Scale.Week)).replace("::TimeWidgetMonth::", timeNavBuilder.build(this.timetag, Scale.Month)).replace("::TimeWidgetQuarter::", timeNavBuilder.build(this.timetag, Scale.Quarter)).replace("::TimeWidgetYear::", timeNavBuilder.build(this.timetag, Scale.Year)).replace("::LastMondayDate::", Scale.Day.format(date.with(TemporalAdjusters.previousOrSame(DayOfWeek.MONDAY))));
        }

        private boolean ledgersNotFound() {
            return this.ledgers.values().stream().allMatch(DashboardBuilder::notFound);
        }

        private boolean isAnyLedgerMissing() {
            return this.report.requireAllLedgers() && this.ledgers.values().stream().anyMatch(DashboardBuilder::notFound);
        }

        private boolean isVisible(Node node) {
            return this.report.visibility().isVisible(node);
        }

        private Map<String, Ledger> loadLedgers() {
            return this.report.ledgers().stream().collect(HashMap::new, (m, l) -> m.put(l, DashboardBuilder.this.ledgerLoader.ledger((String)l, this.scale, this.timetag)), HashMap::putAll);
        }

        private List<InsightBuilder> loadInsightBuilders() {
            return this.report.insights().stream().map(insight -> new InsightBuilder((Dashboard.Insight)insight, this.timetag, this.scale)).collect(Collectors.toList());
        }

        private List<ViewBuilder> loadViewBuilders() {
            return this.report.views().stream().map(insight -> new ViewBuilder((Dashboard.View)insight, this.timetag)).collect(Collectors.toList());
        }

        private Filter slicefilterOf(Ledger ledger, Node node, String ... sliceNames) {
            ArrayList<String> slices = new ArrayList<String>();
            Collections.addAll(slices, sliceNames);
            Collections.addAll(slices, this.report.filters());
            if (node.dimension() != null && !node.name().isEmpty()) {
                slices.add(node.filter());
            }
            return SliceFilter.of(CubesHelper.slices(ledger, slices));
        }

        private Filter dateFilterOf(Ledger ledger, String[] dateFilters) {
            return CubesHelper.dateFilters(ledger, List.of(dateFilters));
        }

        private class ViewBuilder {
            private final Dashboard.View view;
            private final Timetag timetag;
            private final Ledger ledger;
            private final UIBuilder builder;

            public ViewBuilder(Dashboard.View view, Timetag timetag) {
                this.view = view;
                this.timetag = timetag;
                this.ledger = DashboardBuilder.this.ledgerLoader.ledger(view.ledger(), view.period(), timetag);
                this.builder = new JsonBuilder(ReportBuilder.this.report, view);
            }

            public void build(File root) {
                if (DashboardBuilder.notFound(this.ledger)) {
                    return;
                }
                File viewFolder = this.folder(root);
                DashboardBuilder.this.nodes().forEach(node -> this.buildView(viewFolder, (Node)node));
                ZipHelper.zipAndRemove(viewFolder);
            }

            private void buildView(File folder, Node node) {
                String content = this.bodyOf(node);
                if (JsonHelper.isEmptyArray(content)) {
                    return;
                }
                File file = new File(folder, node.id() + ".json");
                DashboardBuilder.save(file, content);
            }

            public String bodyOf(Node node) {
                return this.builder.build(this.cube(node), node);
            }

            private Cube cube(Node node) {
                try {
                    return this.ledger.cube().dimensions(this.dimensions()).filter(this.filter(node)).build();
                }
                catch (Throwable e) {
                    return CubesHelper.emptyCube();
                }
            }

            private List<Dimension> dimensions() {
                return Arrays.stream(this.view.dimensions()).map(arg_0 -> ((Ledger)this.ledger).dimension(arg_0)).collect(Collectors.toList());
            }

            private Filter filter(Node node) {
                return CompositeFilter.of((Filter[])new Filter[]{ReportBuilder.this.slicefilterOf(this.ledger, node, this.view.filters(this.timetag)), ReportBuilder.this.dateFilterOf(this.ledger, this.view.dateFilters(this.timetag))});
            }

            public File folder(File root) {
                LocalDate date = this.timetag.datetime().toLocalDate();
                return new File(root, "views/" + this.view.name() + "/" + this.view.period().timetag(date));
            }
        }

        private class InsightBuilder {
            private final Dashboard.Insight insight;
            private final UIBuilder builder;

            public InsightBuilder(Dashboard.Insight insight, Timetag timetag, Scale scale) {
                this.insight = insight;
                this.builder = UIBuilderFactory.builderOf(ReportBuilder.this.report, insight, timetag, scale);
            }

            public String mark() {
                return FormatHelper.translationMark(this.insight.id());
            }

            public String build(Node node) {
                if (!this.isVisible(node)) {
                    return "";
                }
                Node insightNode = this.insightNode(node);
                Node dataNode = insightNode != null ? insightNode : node;
                return this.builder.build(this.cube(dataNode), dataNode);
            }

            private Cube cube(Node node) {
                Ledger ledger = ReportBuilder.this.ledgers.get(this.insight.ledger());
                return ledger != null && !(ledger instanceof EmptyLedger) ? this.cube(ledger, node) : CubesHelper.emptyCube();
            }

            private Cube cube(Ledger ledger, Node node) {
                try {
                    return ledger.cube().dimensions(this.dimensions(ledger)).filter(this.filter(ledger, node)).build();
                }
                catch (Throwable e) {
                    Logger.error((String)("Error creating cube for " + this.insight.id() + ". Empty cube returned"), (Throwable)e);
                    return CubesHelper.emptyCube();
                }
            }

            private List<Dimension> dimensions(Ledger ledger) {
                return Arrays.stream(this.insight.dimensions()).map(arg_0 -> ((Ledger)ledger).dimension(arg_0)).collect(Collectors.toList());
            }

            private Filter filter(Ledger ledger, Node node) {
                return CompositeFilter.of((Filter[])new Filter[]{ReportBuilder.this.slicefilterOf(ledger, node, this.insight.filters(ReportBuilder.this.timetag)), ReportBuilder.this.dateFilterOf(ledger, this.insight.dateFilters(ReportBuilder.this.timetag))});
            }

            private boolean isVisible(Node node) {
                return this.insight.visibility().isVisible(node);
            }

            private Node insightNode(Node current) {
                String name;
                Node.Type type = this.insight.node();
                if (current == null || type == null) {
                    return null;
                }
                String string = type == Node.Type.Global ? "_All" : (name = type == Node.Type.Root ? DashboardBuilder.nodeRootName(current) : null);
                if (name == null) {
                    return null;
                }
                return DashboardBuilder.this.nodes().stream().filter(n -> name.equalsIgnoreCase(n.id())).findFirst().orElse(null);
            }
        }
    }
}

