/*
 * Decompiled with CFR 0.152.
 */
package io.intino.sumus.reporting.loaders;

import io.intino.alexandria.Scale;
import io.intino.alexandria.Timetag;
import io.intino.alexandria.logger.Logger;
import io.intino.sumus.engine.Ledger;
import io.intino.sumus.engine.LedgerDecorator;
import io.intino.sumus.engine.ledgers.EmptyLedger;
import io.intino.sumus.engine.ledgers.columnar.ColumnarLedger;
import io.intino.sumus.engine.ledgers.columnar.ColumnarLedgerDecorator;
import io.intino.sumus.engine.ledgers.composite.CompositeLedger;
import io.intino.sumus.model.LedgerDefinition;
import io.intino.sumus.reporting.helpers.FormatHelper;
import io.intino.sumus.reporting.loaders.LedgerAggregator;
import io.intino.sumus.reporting.model.Period;
import java.io.File;
import java.io.IOException;
import java.text.ParseException;
import java.time.LocalDate;
import java.util.HashMap;
import java.util.Map;

public class LedgerLoader {
    private final File folder;
    private final LedgerDecorator<ColumnarLedger> decorator;
    private final LedgerAggregator aggregator;

    public LedgerLoader(File folder) {
        this.folder = folder;
        this.decorator = new ColumnarLedgerDecorator(folder);
        this.aggregator = new LedgerAggregator(folder);
    }

    public synchronized Ledger ledger(String name, Period period, LocalDate date) {
        return this.ledger(name, (LocalDate[])period.dates(date).toArray(LocalDate[]::new));
    }

    public synchronized Ledger ledger(String name, Timetag timetag) {
        try {
            return this.loadLedger(name, timetag);
        }
        catch (LedgerNotFoundException e) {
            return new EmptyLedger();
        }
        catch (Throwable e) {
            Logger.warn((String)("Error loading ledger: " + name));
            return new EmptyLedger();
        }
    }

    public synchronized Ledger ledger(String name, LocalDate ... dates) {
        try {
            return this.loadLedger(name, dates);
        }
        catch (LedgerNotFoundException e) {
            return new EmptyLedger();
        }
        catch (Throwable e) {
            Logger.warn((String)("Error loading ledger: " + name));
            return new EmptyLedger();
        }
    }

    private Ledger loadLedger(String name, LocalDate ... dates) throws IOException, LedgerNotFoundException, ParseException {
        Map<LocalDate, Ledger> ledgers = this.loadLedgers(name, dates);
        if (ledgers.isEmpty()) {
            throw new LedgerNotFoundException();
        }
        if (ledgers.size() == 1) {
            return ledgers.values().stream().findFirst().orElseThrow(LedgerNotFoundException::new);
        }
        CompositeLedger composite = new CompositeLedger("date");
        ledgers.forEach((date, ledger) -> composite.add(ledger, date));
        return composite;
    }

    private Ledger loadLedger(String name, Timetag timetag) throws IOException, LedgerNotFoundException, ParseException {
        Map<Timetag, Ledger> ledgers = this.loadLedgers(name, timetag);
        if (ledgers.isEmpty()) {
            throw new LedgerNotFoundException();
        }
        return ledgers.values().stream().findFirst().orElseThrow(LedgerNotFoundException::new);
    }

    private Map<LocalDate, Ledger> loadLedgers(String name, LocalDate ... dates) throws IOException, ParseException {
        LedgerDefinition definition = this.definition(name);
        HashMap<LocalDate, Ledger> ledgers = new HashMap<LocalDate, Ledger>();
        for (LocalDate date : dates) {
            Ledger ledger = this.loadLedger(name, definition, date);
            if (ledger == null) continue;
            ledgers.put(date, ledger);
        }
        return ledgers;
    }

    private Map<Timetag, Ledger> loadLedgers(String name, Timetag ... timetags) throws IOException, ParseException {
        LedgerDefinition definition = this.definition(name);
        HashMap<Timetag, Ledger> ledgers = new HashMap<Timetag, Ledger>();
        for (Timetag date : timetags) {
            Ledger ledger = this.loadLedger(name, definition, date);
            if (ledger == null) continue;
            ledgers.put(date, ledger);
        }
        return ledgers;
    }

    private Ledger loadLedger(String name, LedgerDefinition definition, LocalDate date) throws IOException {
        File file = this.ledgerFile(name, date);
        if (file.exists()) {
            return this.ledger(definition, file);
        }
        if (LedgerAggregator.isAggregable(definition)) {
            return this.aggregatedLedger(name, definition, date);
        }
        return null;
    }

    private Ledger loadLedger(String name, LedgerDefinition definition, Timetag timetag) throws IOException {
        File file = this.ledgerFile(name, timetag);
        if (file.exists()) {
            return this.ledger(definition, file);
        }
        if (LedgerAggregator.isAggregable(definition)) {
            return this.aggregatedLedger(name, definition, timetag);
        }
        return null;
    }

    private Ledger aggregatedLedger(String name, LedgerDefinition definition, LocalDate date) {
        return this.aggregatedLedger(name, definition, new Timetag(date, Scale.Day));
    }

    private Ledger aggregatedLedger(String name, LedgerDefinition definition, Timetag timetag) {
        try {
            String[][] content = this.aggregator.aggregate(name, definition, timetag);
            return this.ledger(definition, content);
        }
        catch (Throwable e) {
            Logger.error((Throwable)e);
            return null;
        }
    }

    private Ledger ledger(LedgerDefinition definition, File file) throws IOException {
        return this.decorator.decorate((Ledger)new ColumnarLedger(definition).load(file, "\t"));
    }

    private Ledger ledger(LedgerDefinition definition, String[][] content) {
        return this.decorator.decorate((Ledger)new ColumnarLedger(definition).load(content));
    }

    private LedgerDefinition definition(String type) throws ParseException {
        return LedgerDefinition.load((File)this.folder, (File)new File(this.folder, type + ".ledger"));
    }

    private File ledgerFile(String type, LocalDate date) {
        return new File(this.folder, type + "/" + FormatHelper.timetag(date) + ".tsv");
    }

    private File ledgerFile(String type, Timetag timetag) {
        return new File(this.folder, type + "/" + timetag + ".tsv");
    }

    public static class LedgerNotFoundException
    extends Exception {
    }
}

