/*
 * Decompiled with CFR 0.152.
 */
package io.intino.sumus.reporting.builders.schemas;

import io.intino.sumus.reporting.model.Formatter;
import io.intino.sumus.reporting.model.Order;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.IntStream;

public class Table {
    protected final String id;
    protected final String title;
    protected final List<Attribute> attributes;
    protected List<Row> rows;
    protected Row globalRow;

    public Table(String id, String title, List<Attribute> attributes) {
        this.id = id;
        this.title = title;
        this.attributes = IntStream.range(0, attributes.size()).mapToObj(i -> ((Attribute)attributes.get(i)).index(i)).collect(Collectors.toList());
    }

    public Table rows(List<Row> rows) throws TableChartException {
        for (Row row : rows) {
            this.checkSizes(row);
        }
        this.rows = rows;
        return this;
    }

    public Table globalRow(Row globalRow) {
        this.globalRow = globalRow;
        return this;
    }

    protected void checkSizes(Row row) throws TableChartException {
        if (row.cells.size() != this.attributes.size()) {
            throw new TableChartException("Table row " + row.name + " values don't match attributes size");
        }
    }

    public static Comparator<? super Row> sortMethodOf(Order order) {
        if (order.is(Order.Type.Alphabetically)) {
            return Comparator.comparing(r -> r.name);
        }
        if (order.is(Order.Type.Ascending)) {
            return Table.ascendingComparator(order.indicator());
        }
        if (order.is(Order.Type.Descending)) {
            return Table.descendingComparator(order.indicator());
        }
        return (o1, o2) -> 0;
    }

    private static Comparator<Row> ascendingComparator(String indicator) {
        return (r1, r2) -> Cell.compare(r1.value(indicator), r2.value(indicator));
    }

    private static Comparator<Row> descendingComparator(String indicator) {
        return (r1, r2) -> Cell.compare(r2.value(indicator), r1.value(indicator));
    }

    public static class TableChartException
    extends Exception {
        public TableChartException(String message) {
            super(message);
        }
    }

    public static class Cell {
        private final String attribute;
        private final Object value;
        private final String units;
        private String formattedValue;

        public Cell(String attribute, Object value) {
            this(attribute, value, "");
        }

        public Cell(String attribute, Object value, String units) {
            this.attribute = attribute;
            this.value = value;
            this.units = units;
            this.formattedValue = "" + value;
        }

        public Cell format(Formatter formatter) {
            this.formattedValue = formatter.format(this.value);
            return this;
        }

        public Object value() {
            return this.value;
        }

        public boolean isNumeric() {
            return this.value instanceof Double;
        }

        public static int compare(Cell c1, Cell c2) {
            if (c1 == null || c2 == null) {
                return 0;
            }
            return c1.isNumeric() && c2.isNumeric() ? Double.compare((Double)c1.value, (Double)c2.value) : c1.toString().compareTo(c2.toString());
        }
    }

    public static class Row {
        protected final String name;
        protected List<Cell> cells;
        protected String onMicrosite;
        protected String onClick;

        public Row(String name) {
            this.name = name;
        }

        public Row cells(List<Cell> cells) {
            this.cells = cells;
            return this;
        }

        public Row onMicrosite(String onMicrosite) {
            this.onMicrosite = onMicrosite;
            return this;
        }

        public Row onClick(String onClick) {
            this.onClick = onClick;
            return this;
        }

        public Cell value(String attribute) {
            return this.cells.stream().filter(c -> c.attribute != null && c.attribute.equalsIgnoreCase(attribute)).findFirst().orElse(null);
        }
    }

    public static class Attribute {
        private final String id;
        private final String label;
        private int index;

        public Attribute(String id, String label) {
            this.id = id;
            this.label = label;
        }

        protected Attribute index(int index) {
            this.index = index;
            return this;
        }

        public String id() {
            return this.id;
        }

        public String label() {
            return this.label;
        }

        public int index() {
            return this.index;
        }
    }
}

