/*
 * Decompiled with CFR 0.152.
 */
package io.intino.sumus.reporting.builders.schemas;

import io.intino.sumus.reporting.helpers.FormatHelper;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;

public class MicrositeAction {
    private final String ledger;
    private final String startDate;
    private final String endDate;
    private List<MicrositeFilter> filters = new ArrayList<MicrositeFilter>();
    private List<MicrositeFilter> dateFilters = new ArrayList<MicrositeFilter>();
    private String title = "";
    private String subtitle = "";

    public MicrositeAction(String ledger, LocalDate startDate, LocalDate endDate) {
        this.ledger = ledger;
        this.startDate = FormatHelper.timetag(startDate);
        this.endDate = FormatHelper.timetag(endDate);
    }

    public MicrositeAction filters(List<String> filters) {
        this.filters = filters.stream().map(MicrositeFilter::new).collect(Collectors.toList());
        return this;
    }

    public MicrositeAction dateFilters(List<String> dateFilters) {
        this.dateFilters = dateFilters.stream().map(MicrositeFilter::new).collect(Collectors.toList());
        return this;
    }

    public MicrositeAction title(String title) {
        this.title = title;
        return this;
    }

    public MicrositeAction subtitle(String subtitle) {
        this.subtitle = subtitle;
        return this;
    }

    private static class MicrositeFilter {
        private final String value;

        public MicrositeFilter(String value) {
            this.value = value;
        }
    }
}

