/*
 * Decompiled with CFR 0.152.
 */
package io.intino.sumus.reporting.builders.schemas;

import io.intino.sumus.reporting.model.Order;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class ColumnChart {
    private final String id;
    private final String title;
    private final Order order;
    private List<Category> categories = new LinkedList<Category>();
    private List<Serie> series = new LinkedList<Serie>();
    private List<PlotLine> plotLines = new LinkedList<PlotLine>();
    private List<CategoryAction> onClick = new LinkedList<CategoryAction>();
    private String units = "";
    private boolean isStacked = false;

    public ColumnChart(String id, String title) {
        this(id, title, null);
    }

    public ColumnChart(String id, String title, Order order) {
        this.id = id;
        this.title = title;
        this.order = order;
    }

    public ColumnChart units(String units) {
        this.units = units;
        return this;
    }

    public ColumnChart stacked(boolean isStacked) {
        this.isStacked = isStacked;
        return this;
    }

    public ColumnChart series(List<Serie> series) {
        this.categories = this.categoriesOf(series).stream().map(Category::new).collect(Collectors.toList());
        this.series = this.sortValues(series);
        return this;
    }

    public ColumnChart plotLines(List<PlotLine> plotLines) {
        this.plotLines = plotLines;
        return this;
    }

    public ColumnChart onClick(List<CategoryAction> onClick) {
        this.onClick = onClick;
        return this;
    }

    private List<String> categoriesOf(List<Serie> series) {
        List<String> categories = this.allCategories(series);
        if (this.order == null) {
            return categories;
        }
        if (this.order.is(Order.Type.Alphabetically)) {
            return categories.stream().sorted().collect(Collectors.toList());
        }
        if (this.order.is(Order.Type.Ascending) || this.order.is(Order.Type.Descending)) {
            return this.categoriesSortedNumerically(categories, series);
        }
        return categories;
    }

    private List<String> categoriesSortedNumerically(List<String> categories, List<Serie> series) {
        Serie serie = this.serie(series, this.order.indicator());
        if (serie == null) {
            return categories;
        }
        return categories.stream().sorted(ColumnChart.sortMethodOf(this.order, serie)).collect(Collectors.toList());
    }

    private static Comparator<String> sortMethodOf(Order order, Serie serie) {
        return (c1, c2) -> {
            Double v1 = serie.doubleValue((String)c1);
            Double v2 = serie.doubleValue((String)c2);
            return order.is(Order.Type.Ascending) ? v1.compareTo(v2) : v2.compareTo(v1);
        };
    }

    private List<String> allCategories(List<Serie> series) {
        return series.stream().flatMap(Serie::categoriesStream).distinct().collect(Collectors.toList());
    }

    private Serie serie(List<Serie> series, String indicator) {
        return series.stream().filter(s -> s.name().equalsIgnoreCase(indicator)).findFirst().orElse(null);
    }

    private List<Serie> sortValues(List<Serie> series) {
        return series.stream().map(s -> s.sortValuesBy(this.categories)).collect(Collectors.toList());
    }

    public static class CategoryAction {
        private final String name;
        private final String action;

        public CategoryAction(String name, String action) {
            this.name = name;
            this.action = action;
        }
    }

    public static class PlotLine {
        private final Double value;
        private String label;
        private String color;

        public PlotLine(Double value) {
            this.value = value;
        }

        public PlotLine(Double value, String label, String color) {
            this.value = value;
            this.label = label;
            this.color = color;
        }
    }

    public static class Serie {
        private final String name;
        private List<Value> values = new LinkedList<Value>();
        private String seriesOnClick;

        public Serie(String name) {
            this.name = name;
        }

        public Serie onClick(String action) {
            this.seriesOnClick = action;
            return this;
        }

        public String name() {
            return this.name;
        }

        public Stream<String> categoriesStream() {
            return this.values.stream().map(v -> v.category);
        }

        public boolean isEmpty() {
            return this.values.stream().allMatch(v -> v.value == 0.0);
        }

        public Double doubleValue(String category) {
            Value value = this.value(category);
            return value != null ? value.value : 0.0;
        }

        private Value value(String category) {
            return this.values.stream().filter(v -> v.category.equalsIgnoreCase(category)).findFirst().orElse(null);
        }

        public Serie addValue(String category, Double value) {
            this.values.add(new Value(category, value));
            return this;
        }

        private Serie sortValuesBy(List<Category> categories) {
            List newValues = categories.stream().map(c -> c.name).map(c -> new Value((String)c, this.doubleValue((String)c))).collect(Collectors.toList());
            this.values = newValues;
            return this;
        }

        private class Value {
            private final Double value;
            private final String serie;
            private final String category;
            private String onClick;

            public Value(String category, Double value) {
                this.value = value;
                this.category = category;
                this.serie = Serie.this.name.toLowerCase().replace(" ", "");
                this.onClick = Serie.this.seriesOnClick;
            }
        }
    }

    private static class Category {
        private final String name;

        public Category(String name) {
            this.name = name;
        }
    }
}

