/*
 * Decompiled with CFR 0.152.
 */
package io.intino.sumus.reporting.builders;

import io.intino.sumus.reporting.Dashboard;
import io.intino.sumus.reporting.builders.ColumnChartBuilder;
import io.intino.sumus.reporting.builders.ColumnSwapViewBuilder;
import io.intino.sumus.reporting.builders.ColumnViewBuilder;
import io.intino.sumus.reporting.builders.GaugeChartBuilder;
import io.intino.sumus.reporting.builders.HeatmapViewBuilder;
import io.intino.sumus.reporting.builders.HtmlBuilder;
import io.intino.sumus.reporting.builders.LineViewBuilder;
import io.intino.sumus.reporting.builders.MicrositeActionBuilder;
import io.intino.sumus.reporting.builders.MicrositeBuilder;
import io.intino.sumus.reporting.builders.PieChartBuilder;
import io.intino.sumus.reporting.builders.StackedColumnChartBuilder;
import io.intino.sumus.reporting.builders.TableBarBuilder;
import io.intino.sumus.reporting.builders.TableBuilder;
import io.intino.sumus.reporting.builders.TableViewBuilder;
import io.intino.sumus.reporting.builders.UIBuilder;
import io.intino.sumus.reporting.model.Period;
import java.time.LocalDate;

public class UIBuilderFactory {
    public static UIBuilder builderOf(Dashboard.Report report, Dashboard.Insight insight, LocalDate date, Period period) {
        MicrositeActionBuilder microsite = new MicrositeActionBuilder(insight, report, date, period);
        switch (insight.type()) {
            case Table: {
                return new TableBuilder(report, insight, microsite);
            }
            case TableBar: {
                return new TableBarBuilder(report, insight, microsite);
            }
            case Pie: {
                return new PieChartBuilder(report, insight, microsite);
            }
            case Gauge: {
                return new GaugeChartBuilder(report, insight, microsite);
            }
            case Column: {
                return new ColumnChartBuilder(report, insight, microsite);
            }
            case StackedColumn: {
                return new StackedColumnChartBuilder(report, insight, microsite);
            }
            case Microsite: {
                return new MicrositeBuilder(insight, microsite);
            }
            case Html: {
                return new HtmlBuilder(insight);
            }
            case TableView: {
                return new TableViewBuilder(report, insight, date);
            }
            case LineView: {
                return new LineViewBuilder(report, insight, date);
            }
            case ColumnView: {
                return new ColumnViewBuilder(report, insight, date);
            }
            case ColumnSwapView: {
                return new ColumnSwapViewBuilder(report, insight, date);
            }
            case HeatmapView: {
                return new HeatmapViewBuilder(report, insight, date);
            }
        }
        return (cube, node) -> "";
    }
}

