/*
 * Decompiled with CFR 0.152.
 */
package io.intino.sumus.reporting.builders;

import io.intino.sumus.reporting.builders.schemas.TimeNavigator;
import io.intino.sumus.reporting.builders.templates.Renderer;
import io.intino.sumus.reporting.model.Scale;
import java.time.LocalDate;

public class TimeNavigatorBuilder {
    public String build(LocalDate date, Scale scale) {
        TimeNavigator chart = new TimeNavigator(date, scale, this.previous(date, scale), this.next(date, scale));
        return Renderer.render(chart);
    }

    private LocalDate next(LocalDate date, Scale scale) {
        LocalDate scaleStart = scale.startDate(date);
        if (scale == Scale.Week) {
            return scale.endDate(scaleStart.plusWeeks(1L));
        }
        if (scale == Scale.Month) {
            return scale.endDate(scaleStart.plusMonths(1L));
        }
        if (scale == Scale.Quarter) {
            return scale.endDate(scaleStart.plusMonths(3L));
        }
        if (scale == Scale.Year) {
            return scale.endDate(scaleStart.plusYears(1L));
        }
        return scaleStart.plusDays(1L);
    }

    private LocalDate previous(LocalDate date, Scale scale) {
        LocalDate scaleStart = scale.startDate(date);
        if (scale == Scale.Week) {
            return scale.endDate(scaleStart.minusWeeks(1L));
        }
        if (scale == Scale.Month) {
            return scale.endDate(scaleStart.minusMonths(1L));
        }
        if (scale == Scale.Quarter) {
            return scale.endDate(scaleStart.minusMonths(3L));
        }
        if (scale == Scale.Year) {
            return scale.endDate(scaleStart.minusYears(1L));
        }
        return scaleStart.minusDays(1L);
    }
}

