/*
 * Decompiled with CFR 0.152.
 */
package io.intino.sumus.reporting.builders;

import io.intino.sumus.engine.Slice;
import io.intino.sumus.reporting.Dashboard;
import io.intino.sumus.reporting.builders.schemas.MicrositeAction;
import io.intino.sumus.reporting.builders.templates.Renderer;
import io.intino.sumus.reporting.model.Period;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;

public class MicrositeActionBuilder {
    private final Dashboard.Insight insight;
    private final Dashboard.Report report;
    private final LocalDate date;
    private final Period period;

    public MicrositeActionBuilder(Dashboard.Insight insight, Dashboard.Report report, LocalDate date, Period period) {
        this.insight = insight;
        this.report = report;
        this.date = date;
        this.period = period;
    }

    public String action(Dashboard.Node node, List<? extends Slice> slices) {
        return this.action(node, slices.toArray(new Slice[0]));
    }

    public String action(Dashboard.Node node, Slice ... slices) {
        List<String> filters = this.filters(node, slices);
        MicrositeAction action = new MicrositeAction(this.insight.ledger(), this.period.startDate(this.date), this.date).filters(filters).dateFilters(this.dateFilters()).title(this.title()).subtitle(this.subtitle(filters));
        return Renderer.render(action);
    }

    private String title() {
        return this.report.name() + " " + this.period.format(this.date);
    }

    private String subtitle(List<String> filters) {
        return filters.stream().map(f -> f.split(":")).filter(f -> ((String[])f).length > 1).map(f -> f[1]).collect(Collectors.joining(" - "));
    }

    private List<String> dateFilters() {
        return List.of(this.insight.dateFilters(this.date));
    }

    private List<String> filters(Dashboard.Node node, Slice ... slices) {
        ArrayList<String> filters = new ArrayList<String>();
        if (!this.isSameDimension(node, slices)) {
            filters.add(node.filter());
        }
        filters.addAll(this.filters(slices));
        filters.addAll(this.insightFilters());
        Collections.addAll(filters, this.report.filters());
        return filters;
    }

    private List<String> filters(Slice ... slices) {
        return Arrays.stream(slices).map(slice -> slice.dimension().name() + ":" + slice.name()).collect(Collectors.toList());
    }

    private List<String> insightFilters() {
        return Arrays.stream(this.insight.filters(this.date)).collect(Collectors.toList());
    }

    private boolean isSameDimension(Dashboard.Node node, Slice ... slices) {
        return Arrays.stream(slices).anyMatch(s -> this.isSameDimension(node, (Slice)s));
    }

    private boolean isSameDimension(Dashboard.Node node, Slice slice) {
        return node.dimension().equalsIgnoreCase(slice.dimension().name());
    }
}

