/*
 * Decompiled with CFR 0.152.
 */
package io.intino.sumus.reporting;

import io.intino.sumus.engine.Ledger;
import io.intino.sumus.reporting.Dashboard;
import io.intino.sumus.reporting.loaders.LedgerLoader;
import io.intino.sumus.reporting.loaders.NodeLoader;
import io.intino.sumus.reporting.model.DashboardDefinition;
import io.intino.sumus.reporting.model.Period;
import java.io.File;
import java.time.LocalDate;
import java.util.List;
import java.util.Set;

public class DashboardInstance
implements Dashboard {
    private final DashboardDefinition definition;
    private final LedgerLoader ledgerLoader;
    private final NodeLoader nodeLoader;

    public DashboardInstance(String json) {
        this.definition = DashboardDefinition.load(json);
        this.ledgerLoader = new LedgerLoader(this.definition.datamart());
        this.nodeLoader = new NodeLoader(this.definition.navigation(), this.nodeValues());
    }

    public DashboardDefinition definition() {
        return this.definition;
    }

    @Override
    public String name() {
        return this.definition.name();
    }

    @Override
    public File datamart() {
        return this.definition.datamart();
    }

    @Override
    public List<Dashboard.Node> nodes() {
        return this.nodeLoader.nodes();
    }

    @Override
    public List<Dashboard.Report> reports() {
        return this.definition.reports();
    }

    @Override
    public Dashboard.Report report(String name) {
        return this.reports().stream().filter(r -> r.name().equalsIgnoreCase(name)).findFirst().orElse(null);
    }

    @Override
    public boolean isRealtime() {
        return this.definition.isRealtime();
    }

    @Override
    public Ledger ledger(String name, Period period, LocalDate date) {
        return this.ledgerLoader.ledger(name, period, date);
    }

    @Override
    public String template() {
        return this.definition.template();
    }

    private Set<String> nodeValues() {
        return NodeLoader.valuesOf(this.definition.nodesFile());
    }
}

