/*
 * Decompiled with CFR 0.152.
 */
package io.intino.sumus.reporting;

import io.intino.alexandria.logger.Logger;
import io.intino.sumus.engine.Cube;
import io.intino.sumus.engine.Dimension;
import io.intino.sumus.engine.Filter;
import io.intino.sumus.engine.Ledger;
import io.intino.sumus.engine.filters.CompositeFilter;
import io.intino.sumus.engine.filters.SliceFilter;
import io.intino.sumus.engine.ledgers.EmptyLedger;
import io.intino.sumus.reporting.Dashboard;
import io.intino.sumus.reporting.builders.JsonBuilder;
import io.intino.sumus.reporting.builders.NavigationBuilder;
import io.intino.sumus.reporting.builders.TimeNavigatorBuilder;
import io.intino.sumus.reporting.builders.UIBuilder;
import io.intino.sumus.reporting.builders.UIBuilderFactory;
import io.intino.sumus.reporting.helpers.CubesHelper;
import io.intino.sumus.reporting.helpers.FormatHelper;
import io.intino.sumus.reporting.helpers.JsonHelper;
import io.intino.sumus.reporting.helpers.MinifyHelper;
import io.intino.sumus.reporting.helpers.ResourceHelper;
import io.intino.sumus.reporting.helpers.ZipHelper;
import io.intino.sumus.reporting.model.Period;
import io.intino.sumus.reporting.model.Scale;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.StandardOpenOption;
import java.time.DayOfWeek;
import java.time.LocalDate;
import java.time.temporal.TemporalAdjusters;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class DashboardBuilder {
    private static final String BaseHtml = ResourceHelper.dashboardBaseHtml();
    private final Dashboard dashboard;
    private final File folder;

    public DashboardBuilder(Dashboard dashboard, File folder) {
        this.dashboard = dashboard;
        this.folder = new File(folder, dashboard.name());
        this.folder.mkdirs();
    }

    public Dashboard dashboard() {
        return this.dashboard;
    }

    public void build(LocalDate date) {
        this.build(this.reportBuilders(date));
    }

    public void build(Dashboard.Report report, LocalDate date) {
        this.build(this.reportBuilder(report, date));
    }

    public void build(ReportBuilder ... builders) {
        Arrays.stream(builders).forEach(b -> b.build(this.folder));
    }

    public void buildViews(Dashboard.Report report, LocalDate date) {
        this.reportBuilder(report, date).buildViews(this.folder);
    }

    public String buildNodeContent(Dashboard.Report report, LocalDate date, Dashboard.Node node) {
        ReportBuilder reportBuilder = this.reportBuilder(report, date);
        return reportBuilder.ledgersNotFound() ? null : reportBuilder.bodyOf(node);
    }

    private ReportBuilder reportBuilder(Dashboard.Report report, LocalDate date) {
        return new ReportBuilder(report, date);
    }

    private ReportBuilder[] reportBuilders(LocalDate date) {
        return (ReportBuilder[])this.dashboard.reports().stream().map(report -> this.reportBuilder((Dashboard.Report)report, date)).toArray(ReportBuilder[]::new);
    }

    private static String nodeRootName(Dashboard.Node node) {
        return node != null ? node.name().split("\\.")[0] : "";
    }

    protected static boolean notFound(Ledger ledger) {
        return ledger == null || ledger instanceof EmptyLedger;
    }

    private static void save(File file, String content) {
        try {
            file.getParentFile().mkdirs();
            Files.write(file.toPath(), content.getBytes(), StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private class ReportBuilder {
        public final Dashboard.Report report;
        private final Period period = new Period(Scale.Day);
        private final LocalDate date;
        private final NavigationBuilder navBuilder;
        private final Map<String, Ledger> ledgers;
        private final List<ViewBuilder> viewBuilders;
        private final List<InsightBuilder> insightBuilders;

        public ReportBuilder(Dashboard.Report report, LocalDate date) {
            this.report = report;
            this.date = date;
            this.navBuilder = new NavigationBuilder(report);
            this.ledgers = this.loadLedgers();
            this.viewBuilders = this.loadViewBuilders();
            this.insightBuilders = this.loadInsightBuilders();
        }

        public void build(File root) {
            this.buildViews(root);
            this.buildReport(root);
        }

        public void buildViews(File root) {
            this.viewBuilders.forEach(builder -> builder.build(root));
        }

        public void buildReport(File root) {
            if (this.ledgersNotFound()) {
                return;
            }
            if (this.report.requireAllLedgers() && this.isAnyLedgerMissing()) {
                return;
            }
            File reportFolder = this.folder(root);
            DashboardBuilder.this.dashboard.nodes().stream().filter(this::isVisible).forEach(n -> this.buildReport(reportFolder, (Dashboard.Node)n));
            ZipHelper.zipAndRemove(reportFolder);
        }

        private void buildReport(File folder, Dashboard.Node node) {
            File file = new File(folder, node.id() + ".html");
            DashboardBuilder.save(file, this.bodyOf(node));
        }

        public String bodyOf(Dashboard.Node node) {
            String template = this.template(node);
            for (InsightBuilder b : this.insightBuilders) {
                template = template.replace(b.mark(), b.build(node));
            }
            return MinifyHelper.minify(this.replaceGenericMarks(template, node));
        }

        public File folder(File root) {
            String folderName = this.report.isSingleton() ? this.report.name() : this.period.timetag(this.date);
            return new File(root, "reports/" + this.report.name() + "/" + folderName);
        }

        private String template(Dashboard.Node node) {
            return DashboardBuilder.this.dashboard.template() + BaseHtml + this.navBuilder.build(node) + this.reportTemplate();
        }

        private String reportTemplate() {
            String template = this.report.template();
            if (template != null && !template.isEmpty()) {
                return template;
            }
            return this.insightBuilders.stream().map(InsightBuilder::mark).collect(Collectors.joining("\n"));
        }

        private String replaceGenericMarks(String template, Dashboard.Node node) {
            TimeNavigatorBuilder timeNavBuilder = new TimeNavigatorBuilder();
            return template.replace("::CurrentNode::", node.isMain() ? "Global" : node.name()).replace("::CurrentRootNode::", node.isMain() ? "Global" : DashboardBuilder.nodeRootName(node)).replace("::CurrentDayTimetag::", Scale.Day.timetag(this.date)).replace("::CurrentDay::", Scale.Day.format(this.date)).replace("::CurrentWeekDay::", Scale.Week.format(this.date)).replace("::CurrentMonth::", Scale.Month.format(this.date)).replace("::CurrentQuarter::", Scale.Quarter.format(this.date)).replace("::CurrentYear::", Scale.Year.format(this.date)).replace("::PreviousYear::", Scale.Year.format(this.date.minusYears(1L))).replace("::NextYear::", Scale.Year.format(this.date.plusYears(1L))).replace("::TimeWidgetDay::", timeNavBuilder.build(this.date, Scale.Day)).replace("::TimeWidgetWeek::", timeNavBuilder.build(this.date, Scale.Week)).replace("::TimeWidgetMonth::", timeNavBuilder.build(this.date, Scale.Month)).replace("::TimeWidgetQuarter::", timeNavBuilder.build(this.date, Scale.Quarter)).replace("::TimeWidgetYear::", timeNavBuilder.build(this.date, Scale.Year)).replace("::LastMondayDate::", Scale.Day.format(this.date.with(TemporalAdjusters.previousOrSame(DayOfWeek.MONDAY))));
        }

        private boolean ledgersNotFound() {
            return this.ledgers.values().stream().allMatch(DashboardBuilder::notFound);
        }

        private boolean isAnyLedgerMissing() {
            return this.ledgers.values().stream().anyMatch(DashboardBuilder::notFound);
        }

        private boolean isVisible(Dashboard.Node node) {
            return this.report.visibility().isVisible(node);
        }

        private Map<String, Ledger> loadLedgers() {
            return this.report.ledgers().stream().collect(HashMap::new, (m, l) -> m.put(l, DashboardBuilder.this.dashboard.ledger((String)l, this.period, this.date)), HashMap::putAll);
        }

        private List<InsightBuilder> loadInsightBuilders() {
            return this.report.insights().stream().map(insight -> new InsightBuilder((Dashboard.Insight)insight, this.period, this.date)).collect(Collectors.toList());
        }

        private List<ViewBuilder> loadViewBuilders() {
            return this.report.views().stream().map(insight -> new ViewBuilder((Dashboard.View)insight, this.date)).collect(Collectors.toList());
        }

        private Filter slicefilterOf(Ledger ledger, Dashboard.Node node, String ... sliceNames) {
            ArrayList<String> slices = new ArrayList<String>();
            Collections.addAll(slices, sliceNames);
            Collections.addAll(slices, this.report.filters());
            if (!node.name().isEmpty()) {
                slices.add(node.filter());
            }
            return SliceFilter.of(CubesHelper.slices(ledger, slices));
        }

        private Filter dateFilterOf(Ledger ledger, String[] dateFilters) {
            return CubesHelper.dateFilters(ledger, List.of(dateFilters));
        }

        private class ViewBuilder {
            private final Dashboard.View view;
            private final LocalDate date;
            private final Ledger ledger;
            private final UIBuilder builder;

            public ViewBuilder(Dashboard.View view, LocalDate date) {
                this.view = view;
                this.date = date;
                this.builder = new JsonBuilder(ReportBuilder.this.report, view);
                this.ledger = DashboardBuilder.this.dashboard.ledger(view.ledger(), view.period(), date);
            }

            public void build(File root) {
                if (DashboardBuilder.notFound(this.ledger)) {
                    return;
                }
                File viewFolder = this.folder(root);
                DashboardBuilder.this.dashboard.nodes().forEach(node -> this.buildView(viewFolder, (Dashboard.Node)node));
                ZipHelper.zipAndRemove(viewFolder);
            }

            private void buildView(File folder, Dashboard.Node node) {
                String content = this.bodyOf(node);
                if (JsonHelper.isEmptyArray(content)) {
                    return;
                }
                File file = new File(folder, node.id() + ".json");
                DashboardBuilder.save(file, content);
            }

            public String bodyOf(Dashboard.Node node) {
                return this.builder.build(this.cube(node), node);
            }

            private Cube cube(Dashboard.Node node) {
                try {
                    return this.ledger.cube().dimensions(this.dimensions()).filter(this.filter(node)).build();
                }
                catch (Throwable e) {
                    return CubesHelper.emptyCube();
                }
            }

            private List<Dimension> dimensions() {
                return Arrays.stream(this.view.dimensions()).map(arg_0 -> ((Ledger)this.ledger).dimension(arg_0)).collect(Collectors.toList());
            }

            private Filter filter(Dashboard.Node node) {
                return CompositeFilter.of((Filter[])new Filter[]{ReportBuilder.this.slicefilterOf(this.ledger, node, this.view.filters(this.date)), ReportBuilder.this.dateFilterOf(this.ledger, this.view.dateFilters(this.date))});
            }

            public File folder(File root) {
                return new File(root, "views/" + this.view.name() + "/" + this.view.period().timetag(this.date));
            }
        }

        private class InsightBuilder {
            private final Dashboard.Insight insight;
            private final UIBuilder builder;

            public InsightBuilder(Dashboard.Insight insight, Period period, LocalDate date) {
                this.insight = insight;
                this.builder = UIBuilderFactory.builderOf(ReportBuilder.this.report, insight, date, period);
            }

            public String mark() {
                return FormatHelper.translationMark(this.insight.id());
            }

            public String build(Dashboard.Node node) {
                if (!this.isVisible(node)) {
                    return "";
                }
                Dashboard.Node insightNode = this.insightNode(node);
                Dashboard.Node dataNode = insightNode != null ? insightNode : node;
                return this.builder.build(this.cube(dataNode), dataNode);
            }

            private Cube cube(Dashboard.Node node) {
                Ledger ledger = ReportBuilder.this.ledgers.get(this.insight.ledger());
                return ledger != null ? this.cube(ledger, node) : CubesHelper.emptyCube();
            }

            private Cube cube(Ledger ledger, Dashboard.Node node) {
                if (ledger instanceof EmptyLedger) {
                    return CubesHelper.emptyCube();
                }
                try {
                    return ledger.cube().dimensions(this.dimensions(ledger)).filter(this.filter(ledger, node)).build();
                }
                catch (Throwable e) {
                    Logger.error((String)("Error creating cube for " + this.insight.id() + ". Empty cube returned"), (Throwable)e);
                    return CubesHelper.emptyCube();
                }
            }

            private List<Dimension> dimensions(Ledger ledger) {
                return Arrays.stream(this.insight.dimensions()).map(arg_0 -> ((Ledger)ledger).dimension(arg_0)).collect(Collectors.toList());
            }

            private Filter filter(Ledger ledger, Dashboard.Node node) {
                return CompositeFilter.of((Filter[])new Filter[]{ReportBuilder.this.slicefilterOf(ledger, node, this.insight.filters(ReportBuilder.this.date)), ReportBuilder.this.dateFilterOf(ledger, this.insight.dateFilters(ReportBuilder.this.date))});
            }

            private boolean isVisible(Dashboard.Node node) {
                return this.insight.visibility().isVisible(node);
            }

            private Dashboard.Node insightNode(Dashboard.Node current) {
                String name;
                Dashboard.Node.Type type = this.insight.node();
                if (current == null || type == null) {
                    return null;
                }
                String string = type == Dashboard.Node.Type.Global ? "_All" : (name = type == Dashboard.Node.Type.Root ? DashboardBuilder.nodeRootName(current) : null);
                if (name == null) {
                    return null;
                }
                return DashboardBuilder.this.dashboard.nodes().stream().filter(n -> name.equalsIgnoreCase(n.id())).findFirst().orElse(null);
            }
        }
    }
}

