/*
 * Decompiled with CFR 0.152.
 */
package io.intino.sumus.reporting.templates;

import io.intino.alexandria.Timetag;
import io.intino.sumus.reporting.helpers.FormatHelper;
import io.intino.sumus.reporting.model.Scale;
import java.time.LocalDate;

public class TimeNavigationBuilder {
    public String build(LocalDate date, Scale scale) {
        LocalDate previousDate = this.previous(date, scale);
        LocalDate nextDate = this.next(date, scale);
        return "<nav style=\"display: flex; align-items: center;\"><button class=\"navigate-previous-icon\" title=\"" + FormatHelper.translationMark("Previous") + "\" onclick=\"javascript:selectPeriod('" + Timetag.of((LocalDate)previousDate, (io.intino.alexandria.Scale)io.intino.alexandria.Scale.Day) + "')\"></button><p class=\"MuiTypography-root date\">" + scale.format(date) + "</p><button class=\"navigate-next-icon\" title=\"" + FormatHelper.translationMark("Next") + "\" onclick=\"javascript:selectPeriod('" + Timetag.of((LocalDate)nextDate, (io.intino.alexandria.Scale)io.intino.alexandria.Scale.Day) + "')\"></button></nav>";
    }

    private LocalDate next(LocalDate date, Scale scale) {
        LocalDate scaleStart = scale.startDate(date);
        if (scale == Scale.Week) {
            return scale.endDate(scaleStart.plusWeeks(1L));
        }
        if (scale == Scale.Month) {
            return scale.endDate(scaleStart.plusMonths(1L));
        }
        if (scale == Scale.Quarter) {
            return scale.endDate(scaleStart.plusMonths(3L));
        }
        if (scale == Scale.Year) {
            return scale.endDate(scaleStart.plusYears(1L));
        }
        return scaleStart.plusDays(1L);
    }

    private LocalDate previous(LocalDate date, Scale scale) {
        LocalDate scaleStart = scale.startDate(date);
        if (scale == Scale.Week) {
            return scale.endDate(scaleStart.minusWeeks(1L));
        }
        if (scale == Scale.Month) {
            return scale.endDate(scaleStart.minusMonths(1L));
        }
        if (scale == Scale.Quarter) {
            return scale.endDate(scaleStart.minusMonths(3L));
        }
        if (scale == Scale.Year) {
            return scale.endDate(scaleStart.minusYears(1L));
        }
        return scaleStart.minusDays(1L);
    }
}

