/*
 * Decompiled with CFR 0.152.
 */
package io.intino.sumus.reporting.templates;

import io.intino.sumus.engine.Cube;
import io.intino.sumus.engine.Slice;
import io.intino.sumus.reporting.Dashboard;
import io.intino.sumus.reporting.helpers.CubesHelper;
import io.intino.sumus.reporting.helpers.FormatHelper;
import io.intino.sumus.reporting.insights.TableInsight;
import io.intino.sumus.reporting.model.Formatter;
import io.intino.sumus.reporting.templates.TemplateBuilder;
import io.intino.sumus.reporting.templates.html.Microsite;
import io.intino.sumus.reporting.templates.html.Table;
import java.time.LocalDate;
import java.time.LocalTime;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;

public class TableBuilder
implements TemplateBuilder {
    private final TableInsight insight;
    private final Dashboard.Report report;
    private final Microsite microsite;

    public TableBuilder(Dashboard.Report report, Dashboard.Insight insight, Microsite microsite) {
        this.insight = new TableInsight(insight);
        this.report = report;
        this.microsite = microsite;
    }

    @Override
    public String build(Cube cube, Dashboard.Node node) {
        return new Table(this.insight.id()).title(this.insight.label()).attributes(this.attributes()).global(this.globalRow(cube)).rows(this.rows(cube, node)).bars(this.insight.barIndicators()).html();
    }

    private Table.Row[] rows(Cube cube, Dashboard.Node node) {
        return this.insight.dimensions().length > 1 ? this.rowsCells(cube, node) : this.rowSlices(cube, node);
    }

    private Table.Attribute[] attributes() {
        return (Table.Attribute[])Arrays.stream(this.insight.indicators()).map(Table.Attribute::new).toArray(Table.Attribute[]::new);
    }

    private Table.Row globalRow(Cube cube) {
        return this.insight.maxItems() == Integer.MAX_VALUE ? new Table.Row("").values(this.values(cube.cell(""))) : null;
    }

    private Table.Row[] rowsCells(Cube cube, Dashboard.Node node) {
        return (Table.Row[])cube.cells().stream().filter(Objects::nonNull).filter(this::containAllDimensions).filter(this::slicesMatchLevel).map(c -> this.row(c.toString(), cube, node, (Slice[])c.slices().toArray(Slice[]::new))).filter(Objects::nonNull).sorted(Table.Row.sortBy(this.insight.order())).limit(this.insight.maxItems().intValue()).toArray(Table.Row[]::new);
    }

    private boolean containAllDimensions(Cube.Cell cell) {
        List cellDimensions = cell.slices().stream().map(s -> s.dimension().name().toLowerCase()).collect(Collectors.toList());
        return Arrays.stream(this.insight.dimensions()).allMatch(d -> cellDimensions.contains(d.toLowerCase()));
    }

    private Table.Row[] rowSlices(Cube cube, Dashboard.Node node) {
        List<Slice> slices = this.isNavigable(node) && !this.isCustomLevel() ? this.slices(cube, node) : this.slices(cube);
        return (Table.Row[])slices.stream().map(slice -> this.row(slice.name(), cube, node, (Slice)slice)).filter(Objects::nonNull).sorted(Table.Row.sortBy(this.insight.order())).limit(this.insight.maxItems().intValue()).toArray(Table.Row[]::new);
    }

    private Table.Row row(String name, Cube cube, Dashboard.Node node, Slice ... slices) {
        Table.Value[] values = this.values(cube.cell(name));
        if (this.areInvalid(values)) {
            return null;
        }
        return new Table.Row(this.insight.translate(name)).values(values).onClick(this.action(name, node)).onMicrosite(this.micrositeAction(node, slices));
    }

    private List<Slice> slices(Cube cube, Dashboard.Node node) {
        return node.children().stream().map(Dashboard.Node::name).map(arg_0 -> ((Cube)cube).cell(arg_0)).filter(Objects::nonNull).flatMap(c -> c.slices().stream()).collect(Collectors.toList());
    }

    private List<Slice> slices(Cube cube) {
        return cube.dimensions().stream().flatMap(d -> d.slices(this.level()).stream()).collect(Collectors.toList());
    }

    private boolean slicesMatchLevel(Cube.Cell cell) {
        return !this.isCustomLevel() || cell.slices().stream().allMatch(this::sliceMatchLevel);
    }

    private boolean sliceMatchLevel(Slice slice) {
        return slice.dimension().levels() <= 1 || slice.level() == this.insight.level().intValue();
    }

    private int level() {
        return this.insight.level() != null ? this.insight.level() : 100;
    }

    private String action(String name, Dashboard.Node node) {
        return this.isNavigable(node) ? TableBuilder.openNodeAction(name) : null;
    }

    public static String openNodeAction(String name) {
        return "javascript:openNode('" + name + "')";
    }

    private String micrositeAction(Dashboard.Node node, Slice ... slices) {
        return this.microsite.action(node, slices);
    }

    private Table.Value[] values(Cube.Cell cell) {
        return (Table.Value[])Arrays.stream(this.insight.indicators()).map(i -> CubesHelper.indicatorOf(this.report, cell, i)).map(this::tableValue).toArray(Table.Value[]::new);
    }

    private Table.Value tableValue(Cube.Indicator indicator) {
        return new Table.Value(indicator.name(), this.value(indicator), indicator.units(), this.formatter(indicator));
    }

    private Formatter formatter(Cube.Indicator indicator) {
        return this.report.formatter(this.insight.format(indicator.name()));
    }

    private Object value(Cube.Indicator indicator) {
        Object value = indicator.value();
        if (value instanceof LocalTime || value instanceof LocalDate) {
            return value;
        }
        return CubesHelper.doubleValueOf(indicator);
    }

    private Integer trimLevel(Dashboard.Node node) {
        return this.isCustomLevel() ? this.insight.level() : (this.isNavigable(node) ? Integer.valueOf(FormatHelper.nextLevel(node)) : null);
    }

    private boolean isNavigable(Dashboard.Node node) {
        return this.insight.dimensions().length == 1 && this.insight.dimensions()[0].equalsIgnoreCase(node.dimension());
    }

    private boolean isCustomLevel() {
        return this.insight.level() != null;
    }

    private boolean areInvalid(Table.Value ... values) {
        return Arrays.stream(values).allMatch(v -> {
            Object object = v.value();
            if (object instanceof Double) {
                Double value = (Double)object;
                return value == 0.0 || value.equals(Double.NaN) || value.longValue() == Long.MAX_VALUE || value.longValue() == Long.MIN_VALUE;
            }
            return object == null || object == LocalDate.MAX || object == LocalDate.MIN || object == LocalTime.MAX || object == LocalTime.MIN;
        });
    }
}

