/*
 * Decompiled with CFR 0.152.
 */
package io.intino.sumus.reporting.templates;

import io.intino.sumus.reporting.Dashboard;
import io.intino.sumus.reporting.model.Period;
import io.intino.sumus.reporting.templates.ColumnChartBuilder;
import io.intino.sumus.reporting.templates.ColumnSwapViewBuilder;
import io.intino.sumus.reporting.templates.ColumnViewBuilder;
import io.intino.sumus.reporting.templates.GaugeChartBuilder;
import io.intino.sumus.reporting.templates.HeatmapViewBuilder;
import io.intino.sumus.reporting.templates.HtmlBuilder;
import io.intino.sumus.reporting.templates.JsonBuilder;
import io.intino.sumus.reporting.templates.LineViewBuilder;
import io.intino.sumus.reporting.templates.PieChartBuilder;
import io.intino.sumus.reporting.templates.StackedColumnChartBuilder;
import io.intino.sumus.reporting.templates.TableBuilder;
import io.intino.sumus.reporting.templates.TableViewBuilder;
import io.intino.sumus.reporting.templates.TemplateBuilder;
import io.intino.sumus.reporting.templates.html.Microsite;
import java.time.LocalDate;

public class TemplateFactory {
    public static TemplateBuilder builderOf(Dashboard.Report report, Dashboard.Insight insight, LocalDate date, Period period) {
        Microsite microsite = TemplateFactory.microsite(report, insight, date, period);
        Dashboard.Insight.Type type = insight.type();
        if (type == Dashboard.Insight.Type.Table || type == Dashboard.Insight.Type.TableBar) {
            return new TableBuilder(report, insight, microsite);
        }
        if (type == Dashboard.Insight.Type.Pie) {
            return new PieChartBuilder(report, insight, microsite);
        }
        if (type == Dashboard.Insight.Type.Gauge) {
            return new GaugeChartBuilder(report, insight, microsite);
        }
        if (type == Dashboard.Insight.Type.Column) {
            return new ColumnChartBuilder(report, insight, microsite);
        }
        if (type == Dashboard.Insight.Type.StackedColumn) {
            return new StackedColumnChartBuilder(report, insight, microsite);
        }
        if (type == Dashboard.Insight.Type.TableView) {
            return new TableViewBuilder(report, insight, date);
        }
        if (type == Dashboard.Insight.Type.LineView) {
            return new LineViewBuilder(report, insight, date);
        }
        if (type == Dashboard.Insight.Type.ColumnView) {
            return new ColumnViewBuilder(report, insight, date);
        }
        if (type == Dashboard.Insight.Type.ColumnSwapView) {
            return new ColumnSwapViewBuilder(report, insight, date);
        }
        if (type == Dashboard.Insight.Type.HeatmapView) {
            return new HeatmapViewBuilder(report, insight, date);
        }
        if (type == Dashboard.Insight.Type.Html) {
            return new HtmlBuilder(insight);
        }
        return (cube, node) -> "";
    }

    public static TemplateBuilder builderOf(Dashboard.Report report, Dashboard.View view) {
        return new JsonBuilder(report, view);
    }

    private static Microsite microsite(Dashboard.Report report, Dashboard.Insight insight, LocalDate date, Period period) {
        return new Microsite(insight, report.name(), date, period);
    }
}

