/*
 * Decompiled with CFR 0.152.
 */
package io.intino.sumus.reporting.templates;

import io.intino.sumus.engine.Cube;
import io.intino.sumus.engine.Slice;
import io.intino.sumus.reporting.Dashboard;
import io.intino.sumus.reporting.helpers.CubesHelper;
import io.intino.sumus.reporting.templates.ColumnChartBuilder;
import io.intino.sumus.reporting.templates.html.Column;
import io.intino.sumus.reporting.templates.html.Microsite;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;

public class StackedColumnChartBuilder
extends ColumnChartBuilder {
    public StackedColumnChartBuilder(Dashboard.Report report, Dashboard.Insight insight, Microsite microsite) {
        super(report, insight, microsite);
    }

    @Override
    public String build(Cube cube, Dashboard.Node node) {
        if (this.insight.dimensions().length != 2) {
            return this.buildBasicColumnChart(cube, node);
        }
        return this.buildStackedColumn(cube, node);
    }

    private String buildBasicColumnChart(Cube cube, Dashboard.Node node) {
        return new ColumnChartBuilder(this.report, this.insight, this.microsite).build(cube, node);
    }

    private String buildStackedColumn(Cube cube, Dashboard.Node node) {
        Column column = new Column(this.insight.id(), this.insight.label());
        column.setStacked(true);
        column.unit(this.units(cube));
        column.add(this.plotLines());
        String indicator = this.insight.indicators()[0];
        List<Slice> categorySlices = this.slices(cube, node, this.insight.dimensions()[0]);
        List<Slice> seriesSlices = this.slices(cube, node, this.insight.dimensions()[1]);
        HashMap<String, Column.Serie> seriesMap = new HashMap<String, Column.Serie>();
        for (Slice categorySlice : categorySlices) {
            column.add(categorySlice.toString());
            for (Slice seriesSlice : seriesSlices) {
                Cube.Cell cell = cube.cell(categorySlice + "-" + seriesSlice);
                double value = CubesHelper.doubleValueOf(CubesHelper.indicatorOf(this.report, cell, indicator));
                seriesMap.putIfAbsent(seriesSlice.toString(), new Column.Serie(seriesSlice.toString()));
                ((Column.Serie)seriesMap.get(seriesSlice.toString())).add(value);
            }
        }
        seriesMap.values().stream().filter(this::isValid).forEach(column::add);
        return column.html();
    }

    private List<Slice> slices(Cube cube, Dashboard.Node node, String dimension) {
        return this.isNavigable(node, dimension) ? this.slices(cube, node) : this.slices(cube, dimension);
    }

    private List<Slice> slices(Cube cube, Dashboard.Node node) {
        return node.children().stream().map(Dashboard.Node::name).map(arg_0 -> ((Cube)cube).cell(arg_0)).filter(Objects::nonNull).flatMap(c -> c.slices().stream()).sorted(Comparator.comparing(Object::toString)).collect(Collectors.toList());
    }

    private List<Slice> slices(Cube cube, String dimension) {
        return cube.dimensions().stream().filter(d -> d.name().equalsIgnoreCase(dimension)).flatMap(d -> d.slices().stream()).sorted(Comparator.comparing(Object::toString)).collect(Collectors.toList());
    }

    private String units(Cube cube) {
        Cube.Cell cell = cube.cell("");
        if (cell == null) {
            return "";
        }
        List units = cell.indicators().stream().map(Cube.Indicator::units).collect(Collectors.toList());
        if (units.isEmpty() || units.contains(null)) {
            return "";
        }
        String unit = (String)units.get(0);
        return units.stream().allMatch(unit::equalsIgnoreCase) ? unit : "";
    }

    private boolean isValid(Column.Serie serie) {
        return serie.values().stream().anyMatch(v -> v != 0.0);
    }
}

