/*
 * Decompiled with CFR 0.152.
 */
package io.intino.sumus.reporting.templates;

import io.intino.sumus.engine.Cube;
import io.intino.sumus.engine.Dimension;
import io.intino.sumus.engine.Slice;
import io.intino.sumus.reporting.Dashboard;
import io.intino.sumus.reporting.helpers.CubesHelper;
import io.intino.sumus.reporting.helpers.FormatHelper;
import io.intino.sumus.reporting.templates.TemplateBuilder;
import io.intino.sumus.reporting.templates.html.Column;
import io.intino.sumus.reporting.templates.html.Microsite;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class ColumnChartBuilder
implements TemplateBuilder {
    private static final int MaxLevel = 100;
    protected final Dashboard.Insight insight;
    protected final Dashboard.Report report;
    protected final Microsite microsite;

    public ColumnChartBuilder(Dashboard.Report report, Dashboard.Insight insight, Microsite microsite) {
        this.report = report;
        this.insight = insight;
        this.microsite = microsite;
    }

    @Override
    public String build(Cube cube, Dashboard.Node node) {
        return this.insight.dimensions().length > 0 ? this.buildSlices(cube, node) : this.buildIndicators(cube, node);
    }

    private String buildSlices(Cube cube, Dashboard.Node node) {
        Column column = new Column(this.insight.id(), this.insight.label());
        column.unit(this.units(cube));
        column.add(this.plotLines());
        Arrays.stream(this.insight.indicators()).map(Column.Serie::new).forEach(column::add);
        for (Cube.Cell cell : this.cells(cube, node)) {
            if (cell == null || cell.toString().isEmpty()) continue;
            String label = this.insight.translate(cell.toString());
            column.add(label);
            column.onClick(label, this.onclickAction(node, cell));
            for (String i : this.insight.indicators()) {
                Column.Serie serie = column.get(i);
                Cube.Indicator indicator = CubesHelper.indicatorOf(this.report, cell, i);
                serie.add(FormatHelper.round(CubesHelper.doubleValueOf(indicator), 2));
            }
        }
        return column.html();
    }

    private String buildIndicators(Cube cube, Dashboard.Node node) {
        Column column = new Column(this.insight.id(), this.insight.label());
        column.add(this.insight.indicators());
        column.unit(this.units(cube));
        column.add(this.plotLines());
        for (Cube.Cell cell : this.cells(cube, node)) {
            Column.Serie serie;
            if (cell == null || this.isInvalid(serie = this.serie(cell))) continue;
            column.add(serie.onClick(this.onclickAction(node, cell)));
        }
        return column.html();
    }

    private String units(Cube cube) {
        Cube.Cell cell = cube.cell("");
        if (cell == null) {
            return "";
        }
        List units = Arrays.stream(this.insight.indicators()).map(i -> CubesHelper.indicatorOf(this.report, cell, i)).filter(Objects::nonNull).map(Cube.Indicator::units).collect(Collectors.toList());
        if (units.isEmpty() || units.contains(null)) {
            return "";
        }
        String unit = (String)units.get(0);
        return units.stream().allMatch(unit::equalsIgnoreCase) ? unit : "";
    }

    private List<Cube.Cell> cells(Cube cube, Dashboard.Node node) {
        if (cube.dimensions().isEmpty()) {
            return Collections.singletonList(cube.cell(""));
        }
        return cube.dimensions().stream().flatMap(d -> this.sliceStream((Dimension)d, node)).map(arg_0 -> ((Cube)cube).cell(arg_0)).filter(c -> c != null && !c.toString().isEmpty()).collect(Collectors.toList());
    }

    private Stream<String> sliceStream(Dimension dimension, Dashboard.Node node) {
        if (this.hasCustomSlices()) {
            return Arrays.stream(this.insight.slices());
        }
        if (this.isNavigable(node, dimension.name())) {
            return node.children().stream().map(Dashboard.Node::name);
        }
        return dimension.slices(100).stream().map(Slice::name);
    }

    private Column.Serie serie(Cube.Cell cell) {
        String label = this.insight.translate(cell.toString());
        Column.Serie serie = new Column.Serie(label);
        Arrays.stream(this.insight.indicators()).map(i -> CubesHelper.indicatorOf(this.report, cell, i)).mapToDouble(CubesHelper::doubleValueOf).map(v -> FormatHelper.round(v, 2)).forEach(serie::add);
        return serie;
    }

    private boolean isInvalid(Column.Serie serie) {
        return !this.hasCustomSlices() && serie.values().stream().allMatch(v -> v == 0.0);
    }

    private String onclickAction(Dashboard.Node node, Cube.Cell cell) {
        return this.microsite.action(node, cell.slices());
    }

    private boolean hasCustomSlices() {
        return this.insight.slices().length > 0;
    }

    protected Column.PlotLine[] plotLines() {
        String plotlines = this.insight.options().get("plot-lines");
        if (plotlines == null) {
            return new Column.PlotLine[0];
        }
        return (Column.PlotLine[])Arrays.stream(plotlines.split(",")).map(line -> line.split(":")).map(d -> new Column.PlotLine(d[0], ((String[])d).length > 1 ? d[1] : null, ((String[])d).length > 2 ? d[2] : null)).toArray(Column.PlotLine[]::new);
    }

    protected boolean isNavigable(Dashboard.Node node, String dimension) {
        return node.dimension().equalsIgnoreCase(dimension);
    }
}

