/*
 * Decompiled with CFR 0.152.
 */
package io.intino.sumus.reporting;

import io.intino.sumus.engine.Ledger;
import io.intino.sumus.reporting.model.CustomIndicator;
import io.intino.sumus.reporting.model.Formatter;
import io.intino.sumus.reporting.model.Order;
import io.intino.sumus.reporting.model.Period;
import io.intino.sumus.reporting.model.Scale;
import io.intino.sumus.reporting.model.Visibility;
import java.io.File;
import java.time.LocalDate;
import java.util.List;
import java.util.Map;
import java.util.Set;

public interface Dashboard {
    public String name();

    public File datamart();

    public List<Node> nodes();

    public List<Report> reports();

    public Report report(String var1);

    public Ledger ledger(String var1, Period var2, LocalDate var3);

    public boolean isRealtime();

    default public String template() {
        return "";
    }

    public static interface Insight {
        public String id();

        public String label();

        public Type type();

        public String ledger();

        public String[] dimensions();

        public String[] filters();

        public String[] filters(LocalDate var1);

        public String[] indicators();

        public String[] slices();

        public Integer level();

        public Visibility visibility();

        public Order order();

        public Integer maxItems();

        public Map<String, String> options();

        public String node();

        public Map<String, String> labels();

        default public String translate(String label) {
            return this.labels().getOrDefault(label, label);
        }

        public Map<String, String> formats();

        default public String format(String indicator) {
            return this.formats().get(indicator);
        }

        public static enum Type {
            Table,
            TableBar,
            Pie,
            Gauge,
            Column,
            StackedColumn,
            Json,
            Html,
            TableView,
            LineView,
            HeatmapView,
            ColumnView,
            ColumnSwapView;

        }
    }

    public static interface View {
        public String label();

        public String name();

        public String ledger();

        public String[] dimensions();

        public String[] filters();

        public String[] filters(LocalDate var1);

        public String[] indicators();

        public Integer level();

        default public Period period() {
            return new Period(Scale.Day);
        }
    }

    public static interface Report {
        public String name();

        public String group();

        public String description();

        public String template();

        public Set<String> ledgers();

        public List<View> views();

        public List<Insight> insights();

        public List<CustomIndicator> customIndicators();

        public Map<String, Formatter> formatters();

        public Visibility visibility();

        public String[] filters();

        public boolean requireAllLedgers();

        public boolean isSingleton();

        public boolean isRealtime();

        default public Formatter formatter(String name) {
            return this.formatters().getOrDefault(name, new Formatter());
        }

        default public Period[] periods() {
            return new Period[]{new Period(Scale.Day)};
        }
    }

    public static interface Node {
        public String id();

        public String name();

        public String dimension();

        public Node parent();

        public List<Node> children();

        default public String filter() {
            return this.dimension() + ":" + this.name();
        }

        default public boolean isRoot() {
            return this.parent() == null;
        }

        default public boolean isMain() {
            return this.id().equals("_All");
        }

        default public boolean isLeave() {
            return this.children().isEmpty();
        }
    }
}

