/*
 * Decompiled with CFR 0.152.
 */
package io.intino.sumus.reporting.templates;

import io.intino.sumus.engine.Cube;
import io.intino.sumus.engine.Slice;
import io.intino.sumus.reporting.Dashboard;
import io.intino.sumus.reporting.helpers.CubesHelper;
import io.intino.sumus.reporting.templates.TemplateBuilder;
import io.intino.sumus.reporting.templates.html.Microsite;
import io.intino.sumus.reporting.templates.html.Pie;
import java.util.LinkedList;
import java.util.List;
import java.util.stream.Collectors;

public class PieChartBuilder
implements TemplateBuilder {
    private final Dashboard.Insight insight;
    private final Dashboard.Report report;
    private final Microsite microsite;

    public PieChartBuilder(Dashboard.Report report, Dashboard.Insight insight, Microsite microsite) {
        this.report = report;
        this.insight = insight;
        this.microsite = microsite;
    }

    @Override
    public String build(Cube cube, Dashboard.Node node) {
        return new Pie(this.insight.id(), this.insight.label()).order(this.insight.order()).addAll(this.pieSlices(cube, node)).html();
    }

    private List<Pie.Slice> pieSlices(Cube cube, Dashboard.Node node) {
        return this.insight.dimensions().length > 0 ? this.dimensionSlices(cube, node) : this.indicatorSlices(cube, node);
    }

    private List<Pie.Slice> dimensionSlices(Cube cube, Dashboard.Node node) {
        String indicator = this.insight.indicators()[0];
        LinkedList<Pie.Slice> pieSlices = new LinkedList<Pie.Slice>();
        for (Slice slice : this.slices(cube)) {
            Cube.Cell cell = cube.cell(slice.name());
            if (cell == null) continue;
            String name = cell.toString();
            int value = CubesHelper.intValueOf(CubesHelper.indicatorOf(this.report, cell, indicator));
            if (name.isEmpty() || value == 0) continue;
            String label = this.insight.translate(name);
            pieSlices.add(new Pie.Slice(label, value).onClick(this.onclickAction(node, cell)));
        }
        return pieSlices;
    }

    private List<Pie.Slice> indicatorSlices(Cube cube, Dashboard.Node node) {
        LinkedList<Pie.Slice> pieSlices = new LinkedList<Pie.Slice>();
        Cube.Cell cell = cube.cell("");
        if (cell == null) {
            return pieSlices;
        }
        for (String indicator : this.insight.indicators()) {
            int value = CubesHelper.intValueOf(CubesHelper.indicatorOf(this.report, cell, indicator));
            if (value == 0) continue;
            String label = this.insight.translate(indicator);
            pieSlices.add(new Pie.Slice(label, value).onClick(this.onclickAction(node, cell)));
        }
        return pieSlices;
    }

    private List<Slice> slices(Cube cube) {
        return cube.dimensions().stream().flatMap(d -> d.slices(this.level()).stream()).collect(Collectors.toList());
    }

    private int level() {
        return this.insight.level() != null ? this.insight.level() : 100;
    }

    private String onclickAction(Dashboard.Node node, Cube.Cell cell) {
        return this.microsite.action(node, cell.slices());
    }
}

