/*
 * Decompiled with CFR 0.152.
 */
package io.intino.sumus.reporting.model;

import io.intino.sumus.reporting.Dashboard;

public enum Visibility {
    All,
    Main,
    Root,
    MainAndRoot,
    Leaves,
    AllButLeaves,
    AllButRoot,
    AllButMain,
    RootWithGrandchildren,
    None;


    public boolean isVisible(Dashboard.Node node) {
        if (None == this) {
            return false;
        }
        if (All == this) {
            return true;
        }
        if (Main == this && node.isMain()) {
            return true;
        }
        if (Root == this && node.isRoot() && !node.isMain()) {
            return true;
        }
        if (MainAndRoot == this && node.isRoot()) {
            return true;
        }
        if (Leaves == this && node.isLeave()) {
            return true;
        }
        if (AllButLeaves == this && !node.isLeave()) {
            return true;
        }
        if (AllButRoot == this && !node.isRoot()) {
            return true;
        }
        if (AllButMain == this && !node.isMain()) {
            return true;
        }
        return RootWithGrandchildren == this && node.isRoot() && !node.isMain() && this.hasGrandChildren(node);
    }

    private boolean hasGrandChildren(Dashboard.Node node) {
        return !node.isLeave() && node.children().stream().anyMatch(n -> !n.isLeave());
    }
}

