/*
 * Decompiled with CFR 0.152.
 */
package io.intino.sumus.reporting.helpers;

import io.intino.alexandria.logger.Logger;
import io.intino.sumus.engine.Cube;
import io.intino.sumus.engine.Dimension;
import io.intino.sumus.engine.Fact;
import io.intino.sumus.engine.Filter;
import io.intino.sumus.engine.Ledger;
import io.intino.sumus.engine.Slice;
import io.intino.sumus.reporting.Dashboard;
import io.intino.sumus.reporting.helpers.FormulaCalculator;
import io.intino.sumus.reporting.model.CustomIndicator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

public class CubesHelper {
    public static Cube.Indicator indicatorOf(Dashboard.Report report, Cube.Cell cell, String name) {
        if (cell == null) {
            return Cube.Indicator.None;
        }
        Cube.Indicator indicator = CubesHelper.formulaIndicator(report, cell, name);
        return indicator != null ? indicator : CubesHelper.indicatorOf(cell, name);
    }

    public static Cube.Indicator indicatorOf(Cube.Cell cell, String name) {
        if (cell == null) {
            return Cube.Indicator.None;
        }
        Cube.Indicator indicator = cell.indicator(name);
        return indicator != null ? indicator : Cube.Indicator.None;
    }

    private static Cube.Indicator formulaIndicator(Dashboard.Report report, Cube.Cell cell, String name) {
        CustomIndicator custom = report.customIndicators().stream().filter(i -> i.name().equalsIgnoreCase(name)).findFirst().orElse(null);
        return custom != null ? CubesHelper.formulaIndicator(report, cell, name, custom) : null;
    }

    private static Cube.Indicator formulaIndicator(Dashboard.Report report, Cube.Cell cell, String name, final CustomIndicator custom) {
        try {
            FormulaCalculator calculator = new FormulaCalculator(report.customIndicators(), cell.indicators());
            final Double value = calculator.value(name);
            return new Cube.Indicator(){

                public String name() {
                    return custom.name();
                }

                public Object value() {
                    return value;
                }

                public String units() {
                    return custom.units();
                }
            };
        }
        catch (Throwable e) {
            Logger.error((String)("Error calculating formula " + name), (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    public static Cube emptyCube() {
        return new Cube(){

            public List<? extends Dimension> dimensions() {
                return Collections.emptyList();
            }

            public List<? extends Cube.Cell> cells() {
                return Collections.emptyList();
            }

            public Map<String, ? extends Cube.Cell> cellMap() {
                return Collections.emptyMap();
            }

            public Iterable<Fact> facts(Filter filter) {
                return Collections::emptyIterator;
            }
        };
    }

    public static List<Slice> slices(Ledger ledger, List<String> rawSlices) {
        ArrayList<Slice> slices = new ArrayList<Slice>();
        CubesHelper.groupByDimension(rawSlices).forEach((dimension, values) -> {
            boolean hasPositives = values.stream().anyMatch(v -> !CubesHelper.isNegative(v));
            if (hasPositives) {
                Set<String> positives = values.stream().filter(v -> !CubesHelper.isNegative(v)).collect(Collectors.toSet());
                slices.addAll(CubesHelper.slices(ledger, dimension, positives));
            } else {
                Set<String> negatives = values.stream().filter(CubesHelper::isNegative).map(v -> v.substring(1)).collect(Collectors.toSet());
                slices.addAll(CubesHelper.excludedSlices(ledger, dimension, negatives));
            }
        });
        return slices;
    }

    private static Map<String, List<String>> groupByDimension(List<String> slices) {
        return slices.stream().map(s -> s.split(":")).collect(Collectors.groupingBy(d -> d[0], Collectors.mapping(d -> d[1], Collectors.toList())));
    }

    private static List<Slice> slices(Ledger ledger, String dimension, Set<String> values) {
        return values.stream().map(v -> ledger.slice(dimension, v)).collect(Collectors.toList());
    }

    private static List<Slice> excludedSlices(Ledger ledger, String dimension, Set<String> excluded) {
        if (excluded.isEmpty()) {
            return new ArrayList<Slice>();
        }
        return ledger.dimension(dimension).slices().stream().filter(s -> excluded.stream().noneMatch(e -> e.equalsIgnoreCase(s.name()))).collect(Collectors.toList());
    }

    private static boolean isNegative(String value) {
        return value.startsWith("!");
    }

    public static double doubleValueOf(Cube.Indicator indicator) {
        try {
            return Double.parseDouble(indicator.value().toString());
        }
        catch (Throwable e) {
            return 0.0;
        }
    }

    public static int intValueOf(Cube.Indicator indicator) {
        try {
            return Integer.parseInt(indicator.value().toString());
        }
        catch (Throwable e) {
            return 0;
        }
    }
}

