/*
 * Decompiled with CFR 0.152.
 */
package io.intino.sumus.reporting.templates.html;

import io.intino.sumus.reporting.helpers.FormatHelper;
import java.util.Map;
import java.util.stream.Collectors;

public class Gauge {
    private static final String DefaultColor = "#001e6d";
    private final String id;
    private final String title;
    private double value;
    private String onClick;
    private Map<Double, String> stopColorMap;

    public Gauge(String id, String title) {
        this.id = id;
        this.title = title;
        this.value = 0.0;
        this.stopColorMap = Map.of(1.0, DefaultColor);
    }

    public Gauge value(double value) {
        this.value = value;
        return this;
    }

    public Gauge stops(Map<Double, String> stopColors) {
        this.stopColorMap = stopColors;
        return this;
    }

    public Gauge onClick(String onClick) {
        this.onClick = onClick;
        return this;
    }

    public String html() {
        return "<div id=\"" + this.id + "\" class=\"chart gauge\"></div>\n<script>gauge('" + this.id + "', '" + FormatHelper.translationMark(this.title) + "', " + this.data() + ");</script>";
    }

    private String data() {
        double value = FormatHelper.round(this.value, 1);
        return "[{ y: " + value + ", className: 'gauge-bar gauge-bar-" + this.barState(value) + "'" + this.customs() + "}]";
    }

    private String stops() {
        return "[" + this.stopColorMap.entrySet().stream().sorted(Map.Entry.comparingByKey()).map(e -> "[" + e.getKey() + ", '" + (String)e.getValue() + "']").collect(Collectors.joining(",")) + "]";
    }

    private String customs() {
        return this.onClick != null ? ", custom: { onClick: function(){" + this.onClick + "}}" : "";
    }

    private String barState(double value) {
        if (value < 0.0) {
            return "unknown";
        }
        if (value < 25.0) {
            return "low";
        }
        if (value < 50.0) {
            return "mid-low";
        }
        return value < 75.0 ? "mid-high" : "high";
    }
}

