/*
 * Decompiled with CFR 0.152.
 */
package io.intino.sumus.reporting.model.calendars;

import io.intino.sumus.reporting.model.WeekCalendar;
import java.time.DayOfWeek;
import java.time.LocalDate;
import java.time.temporal.IsoFields;
import java.time.temporal.TemporalAdjusters;
import java.time.temporal.WeekFields;
import java.util.List;
import java.util.stream.Collectors;

public class StandardWeekCalendar
implements WeekCalendar {
    public final DayOfWeek WeekStart;

    public StandardWeekCalendar() {
        this(DayOfWeek.MONDAY);
    }

    public StandardWeekCalendar(DayOfWeek weekStart) {
        this.WeekStart = weekStart;
    }

    @Override
    public List<LocalDate> dates(LocalDate to) {
        return this.startDate(to).datesUntil(to.plusDays(1L)).collect(Collectors.toList());
    }

    @Override
    public LocalDate startDate(LocalDate date) {
        return date.with(TemporalAdjusters.previousOrSame(this.WeekStart));
    }

    @Override
    public LocalDate endDate(LocalDate date) {
        return date.with(TemporalAdjusters.nextOrSame(this.WeekStart.minus(1L)));
    }

    @Override
    public String format(LocalDate date) {
        return this.weekyear(date) + "-" + this.weekNumber(date);
    }

    @Override
    public String timetag(LocalDate date) {
        return this.weekyear(date) + "W" + String.format("%02d", this.weekNumber(date));
    }

    @Override
    public String label(LocalDate date) {
        return "W" + this.weekNumber(date);
    }

    private int weekNumber(LocalDate date) {
        return date.with(WeekFields.of(this.WeekStart, 1).dayOfWeek(), 1L).get(IsoFields.WEEK_OF_WEEK_BASED_YEAR);
    }

    private int weekyear(LocalDate date) {
        return date.with(WeekFields.of(this.WeekStart, 1).dayOfWeek(), 1L).get(IsoFields.WEEK_BASED_YEAR);
    }
}

