/*
 * Decompiled with CFR 0.152.
 */
package io.intino.sumus.reporting.model.calendars;

import io.intino.sumus.reporting.model.calendars.StandardWeekCalendar;
import java.io.File;
import java.nio.file.Files;
import java.time.Duration;
import java.time.LocalDate;
import java.util.Map;
import java.util.TreeMap;
import java.util.stream.Stream;

public class CustomWeekCalendar
extends StandardWeekCalendar {
    private final File file;
    private final Map<LocalDate, String> dayWeek = new TreeMap<LocalDate, String>();

    public CustomWeekCalendar(File file) {
        this.file = file;
        this.reload();
    }

    public void reload() {
        this.dayWeek.clear();
        try (Stream<String> lines = Files.lines(this.file.toPath());){
            lines.filter(l -> l != null && !l.isEmpty()).map(l -> l.split("\t")).forEach(d -> this.dayWeek.put(LocalDate.parse(d[1]), d[0]));
        }
        catch (Throwable e) {
            System.err.println("Custom calendar: Error loading map");
            e.printStackTrace();
        }
    }

    @Override
    public LocalDate startDate(LocalDate date) {
        LocalDate start = this.customStartDate(date);
        return start != null ? start : super.startDate(date);
    }

    public LocalDate customStartDate(LocalDate date) {
        LocalDate start = null;
        for (LocalDate weekLastDay : this.dayWeek.keySet()) {
            if (date.isAfter(weekLastDay) && this.isWithinRange(date, weekLastDay)) {
                start = weekLastDay.plusDays(1L);
                continue;
            }
            if (!date.isBefore(weekLastDay) || !this.isWithinRange(date, weekLastDay)) continue;
            break;
        }
        return start;
    }

    @Override
    public LocalDate endDate(LocalDate date) {
        LocalDate end = this.customEndDate(date);
        return end != null ? end : super.endDate(date);
    }

    public LocalDate customEndDate(LocalDate date) {
        for (LocalDate weekLastDay : this.dayWeek.keySet()) {
            LocalDate nextWeekStart = weekLastDay.plusDays(1L);
            if (!date.isBefore(nextWeekStart) || !this.isWithinRange(date, weekLastDay)) continue;
            return weekLastDay;
        }
        return null;
    }

    @Override
    public String format(LocalDate date) {
        String yearWeek = this.yearWeek(date);
        return yearWeek != null ? this.year(yearWeek) + "-" + this.week(yearWeek) : super.format(date);
    }

    @Override
    public String timetag(LocalDate date) {
        String yearWeek = this.yearWeek(date);
        return yearWeek != null ? this.year(yearWeek) + "W" + String.format("%02d", this.week(yearWeek)) : super.timetag(date);
    }

    @Override
    public String label(LocalDate date) {
        String yearWeek = this.yearWeek(date);
        return yearWeek != null ? "W" + this.week(yearWeek) : super.label(date);
    }

    private String yearWeek(LocalDate date) {
        LocalDate endDate = this.customEndDate(date);
        return endDate != null ? this.dayWeek.get(endDate) : null;
    }

    private int week(String yearWeek) {
        return Integer.parseInt(yearWeek.split("\\|")[1]);
    }

    private int year(String yearWeek) {
        return Integer.parseInt(yearWeek.split("\\|")[0]);
    }

    private boolean isWithinRange(LocalDate d1, LocalDate d2) {
        long days = Duration.between(d1.atStartOfDay(), d2.atStartOfDay()).toDays();
        return Math.abs(days) <= 15L;
    }
}

