/*
 * Decompiled with CFR 0.152.
 */
package io.intino.sumus.reporting.helpers;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.file.Files;
import java.nio.file.StandardOpenOption;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;

public class ResourceHelper {
    /*
     * Enabled aggressive exception aggregation
     */
    public static String getResourceFileAsString(String fileName) {
        try (InputStream is = ClassLoader.getSystemClassLoader().getResourceAsStream(fileName);){
            String string;
            if (is == null) {
                String string2 = "";
                return string2;
            }
            try (BufferedReader reader = new BufferedReader(new InputStreamReader(is));){
                string = reader.lines().collect(Collectors.joining("\n"));
            }
            return string;
        }
        catch (Throwable e) {
            return "";
        }
    }

    public static List<String> lines(File file) {
        try {
            return Files.readAllLines(file.toPath());
        }
        catch (IOException e) {
            return Collections.emptyList();
        }
    }

    public static void truncate(File file, Collection<String> lines) {
        try {
            Files.writeString(file.toPath(), (CharSequence)String.join((CharSequence)"\n", lines), StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

