/*
 * Decompiled with CFR 0.152.
 */
package io.intino.sumus.reporting.helpers;

import io.intino.sumus.reporting.Dashboard;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.time.temporal.TemporalAccessor;
import java.util.Locale;

public class FormatHelper {
    private static final Locale Locale = java.util.Locale.GERMAN;

    public static String timetag(LocalDate date) {
        return date.format(DateTimeFormatter.ofPattern("yyyyMMdd"));
    }

    public static double round(double value, int places) {
        double scale = Math.pow(10.0, places);
        return (double)Math.round(value * scale) / scale;
    }

    public static String translationMark(String name) {
        return name != null && !name.isEmpty() ? "::" + name.replace(":", "") + "::" : "";
    }

    public static String labelByLevel(String name, Integer level) {
        if (level == null) {
            return name;
        }
        String[] parts = name.split("\\.");
        return parts.length < level ? name : parts[level - 1];
    }

    public static int nextLevel(Dashboard.Node node) {
        String name = node.name();
        int level = name != null && !name.isEmpty() ? name.split("\\.").length : 0;
        return level + 1;
    }

    public static String format(Double value, String pattern) {
        return pattern != null ? FormatHelper.formatPattern(value, pattern) : FormatHelper.defaultFormat(value);
    }

    public static String format(TemporalAccessor value, String pattern) {
        return pattern != null ? FormatHelper.formatPattern(value, pattern) : value.toString();
    }

    private static String formatPattern(Double value, String pattern) {
        try {
            return new DecimalFormat(pattern, new DecimalFormatSymbols(Locale)).format(value);
        }
        catch (Throwable e) {
            System.err.println("Error using pattern " + pattern);
            e.printStackTrace();
            return FormatHelper.defaultFormat(value);
        }
    }

    private static String formatPattern(TemporalAccessor value, String pattern) {
        try {
            return DateTimeFormatter.ofPattern(pattern).format(value);
        }
        catch (Throwable e) {
            System.err.println("Error using pattern " + pattern);
            e.printStackTrace();
            return value.toString();
        }
    }

    private static String defaultFormat(Double value) {
        return new DecimalFormat("#,##0.#", new DecimalFormatSymbols(Locale)).format(FormatHelper.round(value, 2));
    }
}

