/*
 * Decompiled with CFR 0.152.
 */
package io.intino.sumus.reporting.dashboards;

import io.intino.sumus.engine.Ledger;
import io.intino.sumus.reporting.Dashboard;
import io.intino.sumus.reporting.loaders.LedgerLoader;
import io.intino.sumus.reporting.loaders.NodeLoader;
import io.intino.sumus.reporting.model.DashboardDefinition;
import io.intino.sumus.reporting.model.Period;
import java.io.File;
import java.time.LocalDate;
import java.util.List;
import java.util.Set;

public class DefinedDashboard
implements Dashboard {
    private final DashboardDefinition definition;
    private final LedgerLoader loader;

    public DefinedDashboard(String definition) {
        this.definition = DashboardDefinition.load(definition);
        this.loader = new LedgerLoader(this.definition.datamart());
    }

    public DashboardDefinition definition() {
        return this.definition;
    }

    @Override
    public String name() {
        return this.definition.name();
    }

    @Override
    public File datamart() {
        return this.definition.datamart();
    }

    @Override
    public List<Dashboard.Node> nodes() {
        return new NodeLoader(this.definition.navigation(), this.nodeValues()).nodes();
    }

    @Override
    public List<Dashboard.Report> reports() {
        return this.definition.reports();
    }

    @Override
    public boolean isRealtime() {
        return this.definition.isRealtime();
    }

    @Override
    public Ledger ledger(String name, Period period, LocalDate date) {
        return this.loader.ledger(name, period, date);
    }

    @Override
    public String template() {
        return this.definition.template();
    }

    private Set<String> nodeValues() {
        try {
            return NodeLoader.valuesOf(this.definition.nodesFile());
        }
        catch (Throwable e) {
            return this.definition.nodes();
        }
    }
}

